/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool;

import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.pool.EPPPooledGenericHttpSession;
import com.verisign.epp.pool.EPPPooledSession;
import com.verisign.epp.pool.EPPSessionPoolableFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPHttpSessionPoolableFactory
extends EPPSessionPoolableFactory
implements PooledObjectFactory<EPPPooledSession> {
    private static Logger log = LoggerFactory.getLogger(EPPHttpSessionPoolableFactory.class);

    public EPPHttpSessionPoolableFactory() {
    }

    public EPPHttpSessionPoolableFactory(String aClientId, String aPassword, long aAbsoluteTimeout, long aIdleTimeout) {
        this.clientId = aClientId;
        this.password = aPassword;
        this.absoluteTimeout = aAbsoluteTimeout;
        this.idleTimeout = aIdleTimeout;
    }

    public EPPHttpSessionPoolableFactory(String aClientId, String aPassword, long aMinAbsoluteTimeout, long aMaxAbsoluteTimeout, long aIdleTimeout, String aServerName) {
        this.clientId = aClientId;
        this.password = aPassword;
        this.minAbsoluteTimeout = aMinAbsoluteTimeout;
        this.maxAbsoluteTimeout = aMaxAbsoluteTimeout;
        this.idleTimeout = aIdleTimeout;
        this.serverName = aServerName;
    }

    public void activateObject(PooledObject<EPPPooledSession> aSession) throws Exception {
    }

    public void destroyObject(PooledObject<EPPPooledSession> aSession) throws Exception {
        log.debug("destroyObject(): enter, EPPPooledSessionession id = " + aSession.getObject());
        if (this.initSessionOnMake) {
            EPPSession theSession = (EPPSession)aSession.getObject();
            try {
                if (this.clientTransIdGenerator != null) {
                    theSession.setTransId(this.clientTransIdGenerator.genClientTransId());
                }
                log.debug("destroyObject(): Calling end session");
                theSession.endSession();
            }
            catch (Exception ex) {
                log.debug("destroyObject(): Exception ending session: " + ex);
            }
        } else {
            log.debug("destroyObject(): initSessionOnMake is false, so don't end the session automatically on destroy");
        }
    }

    public PooledObject<EPPPooledSession> makeObject() throws Exception {
        log.debug("makeObject(): enter");
        EPPSession theSession = (EPPSession)((Object)this.makeSession());
        log.debug("makeObject(): Make session with id = " + theSession);
        theSession.setClientID(this.clientId);
        theSession.setPassword(this.password);
        if (this.clientTransIdGenerator != null) {
            theSession.setTransId(this.clientTransIdGenerator.genClientTransId());
        }
        if (this.initSessionOnMake) {
            log.debug("makeObject(): establishing session, with session class " + theSession.getClass().getName());
            try {
                theSession.initSession();
                log.debug("makeObject(): established session, with session class " + theSession.getClass().getName());
            }
            catch (EPPCommandException ex) {
                log.error("makeObject(): error initializing session " + theSession.getClass().getName() + ": " + ex);
                try {
                    theSession.endConnection();
                }
                catch (EPPCommandException ePPCommandException) {
                    // empty catch block
                }
                throw ex;
            }
        }
        log.debug("makeObject(): exit");
        return new DefaultPooledObject((Object)((EPPPooledSession)((Object)theSession)));
    }

    public void passivateObject(PooledObject<EPPPooledSession> aSession) throws Exception {
    }

    public boolean validateObject(PooledObject<EPPPooledSession> aSession) {
        boolean isValid;
        log.debug("validateObject(): enter, session id = " + aSession);
        EPPPooledSession theSession = (EPPPooledSession)aSession.getObject();
        long currentTime = System.currentTimeMillis();
        try {
            if (currentTime - theSession.getCreatedTime() > theSession.getAbsoluteTimeout()) {
                log.debug("validateObject(): session id = " + aSession + " is past absolute timeout");
                isValid = false;
            } else if (System.currentTimeMillis() - theSession.getLastTouched() > this.getIdleTimeout()) {
                log.debug("validateObject(): session id = " + aSession + " is past idle timeout, sending hello");
                theSession.hello();
                theSession.touch();
                isValid = true;
            } else {
                log.debug("validateObject(): session id = " + aSession + " is valid");
                isValid = true;
            }
        }
        catch (Exception ex) {
            log.debug("validateObject(): session id = " + aSession + " caused Exception: " + ex);
            isValid = false;
        }
        log.debug("validateObject(): exit, isValid = " + isValid);
        return isValid;
    }

    protected EPPPooledSession makeSession() throws Exception {
        log.debug("makeSession(): enter");
        String theServerName = this.serverName;
        if (theServerName != null) {
            log.debug("makeSession(): Creating with specified Server Name URL " + theServerName);
            return new EPPPooledGenericHttpSession(theServerName);
        }
        log.debug("makeSession(): Creating with default Server Name URL");
        return new EPPPooledGenericHttpSession();
    }
}

