/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceInfoCmd;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceInfoResp;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.Vector;

public class EPPMaintenance {
    private EPPSession session = null;
    private String transId = null;
    private Vector extensions = null;
    EPPMaintenanceInfoCmd.InfoType infoType = EPPMaintenanceInfoCmd.InfoType.list;
    private String maintenanceId;

    public EPPMaintenance(EPPSession aSession) {
        this.session = aSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void setTransId(String aTransId) {
        this.transId = aTransId;
    }

    public EPPMaintenanceInfoCmd.InfoType getInfoType() {
        return this.infoType;
    }

    public void setInfoType(EPPMaintenanceInfoCmd.InfoType aInfoType) {
        this.infoType = aInfoType;
    }

    public String getMaintenanceId() {
        return this.maintenanceId;
    }

    public void setMaintenanceId(String aMaintenanceId) {
        this.maintenanceId = aMaintenanceId;
        this.infoType = this.maintenanceId != null ? EPPMaintenanceInfoCmd.InfoType.id : EPPMaintenanceInfoCmd.InfoType.list;
    }

    public EPPMaintenanceInfoResp sendInfo() throws EPPCommandException {
        EPPMaintenanceInfoCmd theCommand = new EPPMaintenanceInfoCmd(this.transId);
        if (this.maintenanceId != null) {
            theCommand.setMaintenanceId(this.maintenanceId);
        }
        theCommand.setExtensions(this.extensions);
        this.resetMaintenance();
        return (EPPMaintenanceInfoResp)this.session.processDocument(theCommand, EPPMaintenanceInfoResp.class);
    }

    protected void resetMaintenance() {
        this.transId = null;
        this.extensions = null;
        this.infoType = EPPMaintenanceInfoCmd.InfoType.list;
        this.maintenanceId = null;
    }

    public EPPResponse getResponse() {
        return this.session.getResponse();
    }
}

