/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.unhandlednamespaces.v1_0;

import com.verisign.epp.codec.changepoll.EPPChangeData;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.rgpext.EPPRgpExtInfData;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtInfData;
import com.verisign.epp.codec.unhandlednamespaces.v1_0.EPPUnhandledNamespace;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.interfaces.EPPUnhandledNamespacesLoginAdapter;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPUnhandledNamespacesTst {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPUnhandledNamespacesTst.class);
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public void clearPollQueue() {
        EPPSession theSession = this.createSession();
        try {
            EPPResponse reqResponse = null;
            this.initSession(theSession);
            do {
                theSession.setTransId("ABC-12345");
                theSession.setPollOp("req");
                reqResponse = theSession.sendPoll();
                System.out.println("clearPollQueue: Poll Request Response = [" + reqResponse + "]\n\n");
                if (reqResponse.getResult().getCode() != 1301) continue;
                theSession.setPollOp("ack");
                theSession.setMsgID(reqResponse.getMsgQueue().getId());
                EPPResponse ackResponse = theSession.sendPoll();
                System.out.println("clearPollQueue: Poll Ack Response = [" + ackResponse + "]\n\n");
            } while (reqResponse != null && reqResponse.getResult().getCode() == 1301);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.endSession(theSession);
    }

    @Test
    public void testPollMessages() {
        this.printStart("testDomainInfoNoDnssec");
        this.clearPollQueue();
        EPPSession theSession = this.createSession();
        try {
            this.initSession(theSession);
            EPPDomain theDomain = new EPPDomain(theSession);
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("testPollMessages: Sending domain create of \"un-poll-messages.com\" to have the server create a set of poll messages for testing.");
            theDomain.setTransId("ABC-12345");
            theDomain.addDomainName("un-poll-messages.com");
            theDomain.setAuthString("2fooBAR");
            EPPResponse theResponse = theDomain.sendCreate();
            System.out.println("Domain create for \"un-poll-messages.com\": Response = [" + theResponse + "]\n\n");
            this.endSession(theSession);
            System.out.println("Send poll request for change poll message with no change poll extension in login services.");
            EPPUnhandledNamespacesLoginAdapter theLoginAdapter = new EPPUnhandledNamespacesLoginAdapter();
            theLoginAdapter.addFilterNamespace("urn:ietf:params:xml:ns:changePoll-1.0");
            theSession = this.createSession();
            theSession.setLoginAdapter(theLoginAdapter);
            this.initSession(theSession);
            theSession.setTransId("NO-CHANGEPOLL-1");
            theSession.setPollOp("req");
            theResponse = theSession.sendPoll();
            System.out.println("testPollMessages: Poll Response = [" + theResponse + "]\n\n");
            Assert.assertEquals((long)1301L, (long)theResponse.getResult().getCode());
            Assert.assertEquals((Object)EPPDomainInfoResp.class.getName(), (Object)theResponse.getClass().getName());
            Assert.assertFalse((String)"Response must not have change poll extension", (boolean)theResponse.hasExtension(EPPChangeData.class));
            List<EPPUnhandledNamespace> theUnhandledNamespaces = EPPUnhandledNamespace.fromResponse(theResponse);
            Assert.assertNotNull((String)"Response must include unhandled namespace element", theUnhandledNamespaces);
            Assert.assertEquals((long)1L, (long)theUnhandledNamespaces.size());
            Assert.assertEquals((Object)"urn:ietf:params:xml:ns:changePoll-1.0", (Object)theUnhandledNamespaces.get(0).getNamespaceUri());
            EPPUnhandledNamespace.printUnhandledNamespaces(theUnhandledNamespaces);
            this.endSession(theSession);
            System.out.println("Send poll request for change poll message with no domain object and change poll extension in login services.");
            theLoginAdapter = new EPPUnhandledNamespacesLoginAdapter();
            theLoginAdapter.addFilterNamespace("urn:ietf:params:xml:ns:domain-1.0");
            theLoginAdapter.addFilterNamespace("urn:ietf:params:xml:ns:changePoll-1.0");
            theSession = this.createSession();
            theSession.setLoginAdapter(theLoginAdapter);
            this.initSession(theSession);
            theSession.setTransId("NO-DOMAIN-CHANGEPOLL-1");
            theSession.setPollOp("req");
            theResponse = theSession.sendPoll();
            System.out.println("testPollMessages: Poll Response = [" + theResponse + "]\n\n");
            Assert.assertEquals((long)1301L, (long)theResponse.getResult().getCode());
            Assert.assertEquals((Object)EPPResponse.class.getName(), (Object)theResponse.getClass().getName());
            Assert.assertFalse((String)"Response must not have change poll extension", (boolean)theResponse.hasExtension(EPPChangeData.class));
            theUnhandledNamespaces = EPPUnhandledNamespace.fromResponse(theResponse);
            Assert.assertNotNull((String)"Response must include unhandled namespace elements", theUnhandledNamespaces);
            Assert.assertEquals((long)2L, (long)theUnhandledNamespaces.size());
            Assert.assertEquals((Object)"urn:ietf:params:xml:ns:domain-1.0", (Object)theUnhandledNamespaces.get(0).getNamespaceUri());
            Assert.assertEquals((Object)"urn:ietf:params:xml:ns:changePoll-1.0", (Object)theUnhandledNamespaces.get(1).getNamespaceUri());
            EPPUnhandledNamespace.printUnhandledNamespaces(theUnhandledNamespaces);
            theSession.setTransId("NO-DOMAIN-CHANGEPOLL-ACK-1");
            theSession.setPollOp("ack");
            theSession.setMsgID(theResponse.getMsgQueue().getId());
            theResponse = theSession.sendPoll();
            System.out.println("testPollMessages: Poll Ack Response = [" + theResponse + "]\n\n");
            this.endSession(theSession);
            System.out.println("Send poll request for transfer poll message with no domain object in login services.");
            theLoginAdapter = new EPPUnhandledNamespacesLoginAdapter();
            theLoginAdapter.addFilterNamespace("urn:ietf:params:xml:ns:domain-1.0");
            theSession = this.createSession();
            theSession.setLoginAdapter(theLoginAdapter);
            this.initSession(theSession);
            theSession.setTransId("NO-DOMAIN-1");
            theSession.setPollOp("req");
            theResponse = theSession.sendPoll();
            System.out.println("testPollMessages: Poll Response = [" + theResponse + "]\n\n");
            Assert.assertEquals((long)1301L, (long)theResponse.getResult().getCode());
            Assert.assertEquals((Object)EPPResponse.class.getName(), (Object)theResponse.getClass().getName());
            theUnhandledNamespaces = EPPUnhandledNamespace.fromResponse(theResponse);
            Assert.assertNotNull((String)"Response must include unhandled namespace elements", theUnhandledNamespaces);
            Assert.assertEquals((long)1L, (long)theUnhandledNamespaces.size());
            Assert.assertEquals((Object)"urn:ietf:params:xml:ns:domain-1.0", (Object)theUnhandledNamespaces.get(0).getNamespaceUri());
            EPPUnhandledNamespace.printUnhandledNamespaces(theUnhandledNamespaces);
            theSession.setTransId("NO-DOMAIN-ACK-1");
            theSession.setPollOp("ack");
            theSession.setMsgID(theResponse.getMsgQueue().getId());
            theResponse = theSession.sendPoll();
            System.out.println("testPollMessages: Poll Ack Response = [" + theResponse + "]\n\n");
            this.endSession(theSession);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("testDomainInfoNoDnssec");
    }

    @Test
    public void testDomainInfoNoDnssec() {
        this.printStart("testDomainInfoNoDnssec");
        EPPSession theSession = this.createSession();
        try {
            theSession.setLoginAdapter(new EPPUnhandledNamespacesLoginAdapter("urn:ietf:params:xml:ns:secDNS-1.1"));
            this.initSession(theSession);
            EPPDomain theDomain = new EPPDomain(theSession);
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("testDomainInfoNoDnssec: Sending domain info command with session without DNSSEC extension in login services");
            theDomain.setTransId("ABC-12345");
            theDomain.addDomainName("un-no-dnssec.com");
            EPPDomainInfoResp theResponse = theDomain.sendInfo();
            System.out.println("testDomainInfoNoDnssec: Info Response = [" + theResponse + "]\n\n");
            Assert.assertFalse((String)"Response must not have DNSSEC extension", (boolean)theResponse.hasExtension(EPPSecDNSExtInfData.class));
            List<EPPUnhandledNamespace> theUnhandledNamespaces = EPPUnhandledNamespace.fromResponse(theResponse);
            Assert.assertNotNull((String)"Response must include unhandled namespace element", theUnhandledNamespaces);
            Assert.assertEquals((long)1L, (long)theUnhandledNamespaces.size());
            Assert.assertEquals((Object)"urn:ietf:params:xml:ns:secDNS-1.1", (Object)theUnhandledNamespaces.get(0).getNamespaceUri());
            EPPUnhandledNamespace.printUnhandledNamespaces(theUnhandledNamespaces);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.endSession(theSession);
        this.printEnd("testDomainInfoNoDnssec");
    }

    @Test
    public void testDomainInfoNoRgp() {
        this.printStart("testDomainInfoNoRgp");
        EPPSession theSession = this.createSession();
        try {
            theSession.setLoginAdapter(new EPPUnhandledNamespacesLoginAdapter("urn:ietf:params:xml:ns:rgp-1.0"));
            this.initSession(theSession);
            EPPDomain theDomain = new EPPDomain(theSession);
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("testDomainInfoNoRgp: Sending domain info command with session without RGP extension in login services");
            theDomain.setTransId("ABC-12345");
            theDomain.addDomainName("un-no-rgp.com");
            EPPDomainInfoResp theResponse = theDomain.sendInfo();
            System.out.println("testDomainInfoNoDnssec: Info Response = [" + theResponse + "]\n\n");
            Assert.assertFalse((String)"Response must not have RGP extension", (boolean)theResponse.hasExtension(EPPRgpExtInfData.class));
            List<EPPUnhandledNamespace> theUnhandledNamespaces = EPPUnhandledNamespace.fromResponse(theResponse);
            Assert.assertNotNull((String)"Response must include unhandled namespace element", theUnhandledNamespaces);
            Assert.assertEquals((long)1L, (long)theUnhandledNamespaces.size());
            Assert.assertEquals((Object)"urn:ietf:params:xml:ns:rgp-1.0", (Object)theUnhandledNamespaces.get(0).getNamespaceUri());
            EPPUnhandledNamespace.printUnhandledNamespaces(theUnhandledNamespaces);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.endSession(theSession);
        this.printEnd("testDomainInfoNoRgp");
    }

    private void initSession(EPPSession aSession) {
        this.printStart("initSession");
        aSession.setTransId("ABC-12345-XYZ");
        aSession.setVersion("1.0");
        aSession.setLang("en");
        try {
            aSession.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = aSession.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession(EPPSession aSession) {
        this.printStart("endSession");
        aSession.setTransId("ABC-12345-XYZ");
        try {
            aSession.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = aSession.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    private EPPSession createSession() {
        EPPSession theSession = null;
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    theSession = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                theSession = new EPPSession();
            }
            theSession.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            theSession.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
            theSession.setTransId("ABC-12345-XYZ");
            theSession.setVersion("1.0");
            theSession.setLang("en");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        return theSession;
    }

    @BeforeClass
    public static void beforeClass() {
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String("EPPUnhandledNamespacesTst" + Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String aDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + aDomainName);
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("SAI" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }
}

