/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.loginsecpolicy.v04;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.loginsecpolicy.v04.EPPLoginSecPolicyInfData;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoResp;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.interfaces.registry.v02.EPPRegistry;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.security.SecureRandom;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPLoginSecPolicyRegistryTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPLoginSecPolicyRegistryTst.class);
    private EPPRegistry registry = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new SecureRandom();

    public EPPLoginSecPolicyRegistryTst(String name) {
        super(name);
    }

    public void testInfo() {
        this.printStart("testInfo");
        EPPRegistryInfoResp response = null;
        try {
            this.registry.setTransId("ABC-12345-XYZ");
            this.registry.setInfoMode(EPPRegistryInfoCmd.Mode.system);
            response = this.registry.sendInfo();
            EPPLoginSecPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
            System.out.println("System Info Response = " + response);
            EPPLoginSecPolicyInfData loginSecPolicyExt = (EPPLoginSecPolicyInfData)response.getExtension(EPPLoginSecPolicyInfData.class);
            EPPLoginSecPolicyRegistryTst.assertTrue((loginSecPolicyExt != null ? 1 : 0) != 0);
            if (loginSecPolicyExt != null) {
                System.out.println("Login Security Policy: " + loginSecPolicyExt.getSystem());
            }
            this.printEnd("testInfo");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPLoginSecPolicyRegistryTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.registry = new EPPRegistry(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }
}

