/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.pool.parser.EPPSchemaCachingParserPool;
import com.verisign.epp.transport.client.EPPSSLConfig;
import com.verisign.epp.transport.client.EPPSSLContext;
import com.verisign.epp.transport.client.EPPSSLImpl;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EPPSendReceiveLogger;
import com.verisign.epp.util.EPPXMLStream;
import java.io.DataOutputStream;
import java.io.File;
import java.net.URI;
import java.security.KeyStore;
import net.luminis.quic.QuicClientConnection;
import net.luminis.quic.QuicStream;
import net.luminis.quic.log.NullLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPQuicSession
extends EPPSession {
    private static Logger cat = LoggerFactory.getLogger(EPPQuicSession.class);
    public static final String EOQ_CONNECTION_START_PACKET = "EoQ Connection Start";
    private QuicClientConnection quicConnection = null;
    private QuicStream quickStream = null;
    private String url = null;
    private EPPSSLContext sslContext;
    private static EPPSendReceiveLogger sendReceiveLogger = EPPEnv.getSendReceiveLogger();

    public EPPQuicSession() throws EPPCommandException {
        this.init();
    }

    public EPPQuicSession(String aUrl) throws EPPCommandException {
        this.url = aUrl;
        this.init();
    }

    public EPPQuicSession(String aUrl, EPPSSLContext aSSLContext) throws EPPCommandException {
        this.url = aUrl;
        if (aSSLContext != null) {
            this.sslContext = aSSLContext;
        }
        this.init();
    }

    public EPPQuicSession(String aHostName, int aPortNumber) throws EPPCommandException {
        this.url = "eoq://" + aHostName + ":" + aPortNumber;
        this.init();
    }

    public EPPQuicSession(String aHostName, int aPortNumber, EPPSSLContext aSSLContext) throws EPPCommandException {
        this.url = "eoq://" + aHostName + ":" + aPortNumber;
        if (aSSLContext != null) {
            this.sslContext = aSSLContext;
        }
        this.init();
    }

    @Override
    public void init() throws EPPCommandException {
        try {
            if (this.url == null) {
                this.url = EPPEnv.getServerName();
            }
        }
        catch (EPPEnvException e) {
            cat.error("Error when trying to get EPP Server Name (URL): ", (Throwable)e);
            throw new EPPCommandException("Error when trying to get EPP Server Name (URL): " + e.getMessage());
        }
        try {
            if (this.sslContext != null && this.sslContext.getSslConfig() != null) {
                cat.debug("EPPQuicSession: Initializing SSL with provided EPPSSLContext");
                this.sslContext = EPPSSLImpl.initialize(this.sslContext.getSslConfig());
            } else {
                if (!EPPSSLImpl.isInitialized()) {
                    cat.debug("EPPQuicSession: Initializing SSL with default EPPSSLImpl");
                    EPPSSLImpl.initialize();
                }
                this.sslContext = EPPSSLImpl.getEPPSSLContext();
            }
        }
        catch (Exception ex) {
            cat.error("Exception initializing SSL: " + ex);
            throw new EPPCommandException("Exception initializing SSL", ex);
        }
        EPPSSLConfig theSslConfig = this.sslContext.getSslConfig();
        try {
            QuicClientConnection.Builder theBuilder = QuicClientConnection.newBuilder();
            theBuilder.uri(new URI(this.url));
            theBuilder.applicationProtocol("eoq");
            char[] theTrustStorePassPhrase = null;
            if (theSslConfig.getTrustStorePassPhrase() != null) {
                theTrustStorePassPhrase = theSslConfig.getTrustStorePassPhrase().toCharArray();
            }
            theBuilder.customTrustStore(KeyStore.getInstance(new File(theSslConfig.getTrustStoreFileName()), theTrustStorePassPhrase));
            char[] theIdentityPassPhrase = null;
            if (theSslConfig.getIdentityPassPhrase() != null) {
                theIdentityPassPhrase = theSslConfig.getIdentityPassPhrase().toCharArray();
            }
            theBuilder.clientKeyManager(KeyStore.getInstance(new File(theSslConfig.getIdentityFileName()), theIdentityPassPhrase));
            theBuilder.clientKey(theSslConfig.getIdentityPassPhrase());
            theBuilder.logger((net.luminis.quic.log.Logger)new NullLogger());
            if (EPPEnv.getSSLDisableHostnameVerification()) {
                theBuilder.noServerCertificateCheck();
            }
            theBuilder.socketFactory(null);
            this.quicConnection = theBuilder.build();
            this.quicConnection.connect();
            cat.debug("Created connection to URL: " + this.url);
            this.quickStream = this.quicConnection.createStream(true);
            cat.debug("Created bidirectional stream to URL: " + this.url + ", with id = " + this.quickStream.getStreamId());
            this.inputStream = this.quickStream.getInputStream();
            this.outputStream = this.quickStream.getOutputStream();
            DataOutputStream theStream = new DataOutputStream(this.outputStream);
            theStream.writeInt(EOQ_CONNECTION_START_PACKET.length() + 4);
            theStream.write(EOQ_CONNECTION_START_PACKET.getBytes());
            theStream.flush();
        }
        catch (Exception ex) {
            cat.error("Exception creating QUIC connection/stream: " + ex);
            throw new EPPCommandException("Exception creating QUIC connection/stream", ex);
        }
        this.xmlStream = new EPPXMLStream(EPPSchemaCachingParserPool.getInstance().getPool());
        super.initLoginAdapter();
        cat.debug("Successfully initialized with URL: " + this.url);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String aUrl) {
        this.url = aUrl;
    }
}

