/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdRenewResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.persreg.EPPPersRegCreate;
import com.verisign.epp.codec.persreg.EPPPersRegCreateData;
import com.verisign.epp.codec.persreg.EPPPersRegCreateErrData;
import com.verisign.epp.codec.persreg.EPPPersRegInfoData;
import com.verisign.epp.codec.persreg.EPPPersRegRenewData;
import com.verisign.epp.codec.persreg.EPPPersRegTransferData;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPEmailFwd;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.GregorianCalendar;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPPersRegTst {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPPersRegTst.class);
    private EPPDomain domain = null;
    private EPPEmailFwd email = null;
    private EPPSession session = null;
    private EPPClientCon connection = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    @Test
    public void testPersReg() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.persRegInfo();
            this.persRegCreate();
            this.persRegErrCreate();
            this.persRegRenew();
            this.persRegTransfer();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void persRegInfo() {
        EPPPersRegInfoData ext;
        this.printStart("persRegInfo");
        try {
            System.out.println("\npersRegInfo: Domain Info");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            EPPDomainInfoResp domainResponse = this.domain.sendInfo();
            System.out.println("persRegInfo: Response = [" + domainResponse + "]\n\n");
            if (domainResponse.hasExtension(EPPPersRegInfoData.class)) {
                ext = (EPPPersRegInfoData)domainResponse.getExtension(EPPPersRegInfoData.class);
                System.out.println("persRegInfo: consent id = " + ext.getConsentID());
            } else {
                System.out.println("persRegInfo: Response has no extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\npersRegInfo: EmailFwd Info");
            this.email.setTransId("ABC-12345-XYZ");
            this.email.addEmailFwdName(this.makeEmail());
            EPPEmailFwdInfoResp emailResponse = this.email.sendInfo();
            System.out.println("persRegInfo: Response = [" + emailResponse + "]\n\n");
            if (emailResponse.hasExtension(EPPPersRegInfoData.class)) {
                ext = (EPPPersRegInfoData)emailResponse.getExtension(EPPPersRegInfoData.class);
                System.out.println("persRegInfo: consent id = " + ext.getConsentID());
            } else {
                System.out.println("persRegInfo: Response has no extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("persRegInfo");
    }

    public void persRegCreate() {
        EPPPersRegCreateData ext;
        this.printStart("persRegCreate");
        try {
            System.out.println("persRegCreate: Domain Create");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPPersRegCreate("ID:12345"));
            EPPDomainCreateResp domainResponse = this.domain.sendCreate();
            System.out.println("persRegCreate: Response = [" + domainResponse + "]\n\n");
            if (domainResponse.hasExtension(EPPPersRegCreateData.class)) {
                ext = (EPPPersRegCreateData)domainResponse.getExtension(EPPPersRegCreateData.class);
                System.out.println("persRegCreate: bundled rate = " + ext.isBundledRate());
            } else {
                System.out.println("persRegCreate: Response has no extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("persRegCreate: EmailFwd Create");
            this.email.setTransId("ABC-12345-XYZ");
            this.email.addEmailFwdName(this.makeEmail());
            this.email.setForwardTo("jdoe@example.com");
            this.email.setAuthString("ClientX");
            this.email.addExtension(new EPPPersRegCreate("ID:12345"));
            EPPEmailFwdCreateResp emailResponse = this.email.sendCreate();
            System.out.println("persRegCreate: Response = [" + emailResponse + "]\n\n");
            if (emailResponse.hasExtension(EPPPersRegCreateData.class)) {
                ext = (EPPPersRegCreateData)emailResponse.getExtension(EPPPersRegCreateData.class);
                System.out.println("persRegCreate: bundled rate = " + ext.isBundledRate());
            } else {
                System.out.println("persRegCreate: Response has no extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("persRegCreate");
    }

    public void persRegErrCreate() {
        EPPPersRegCreateErrData ext;
        EPPResponse errResponse;
        this.printStart("persRegErrCreate");
        try {
            System.out.println("persRegErrCreate: Domain Create");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName("error" + this.makeDomainName());
            this.domain.setAuthString("ClientX");
            EPPDomainCreateResp domainResponse = this.domain.sendCreate();
            Assert.fail((String)("persRegErrCreate: Unexpected success with create: " + domainResponse));
        }
        catch (EPPCommandException e) {
            errResponse = e.getResponse();
            System.out.println("persRegErrCreate: Error Response = [" + errResponse + "]\n\n");
            if (errResponse.hasExtension(EPPPersRegCreateErrData.class)) {
                ext = (EPPPersRegCreateErrData)errResponse.getExtension(EPPPersRegCreateErrData.class);
                if (ext.getCode() == 1) {
                    System.out.println("persRegErrCreate: Corresponding Service Exists");
                } else if (ext.getCode() == 2) {
                    System.out.println("persRegErrCreate: Defensive Registration Exists");
                }
            }
            System.out.println("persRegErrCreate: Response has no extension");
        }
        try {
            System.out.println("persRegErrCreate: EmailFwd Create");
            this.email.setTransId("ABC-12345-XYZ");
            this.email.addEmailFwdName("error" + this.makeEmail());
            this.email.setForwardTo("jdoe@example.com");
            this.email.setAuthString("ClientX");
            EPPEmailFwdCreateResp emailResponse = this.email.sendCreate();
            Assert.fail((String)("persRegErrCreate: Unexpected success with create: " + emailResponse));
        }
        catch (EPPCommandException e) {
            errResponse = e.getResponse();
            System.out.println("persRegErrCreate: Error Response = [" + errResponse + "]\n\n");
            if (errResponse.hasExtension(EPPPersRegCreateErrData.class)) {
                ext = (EPPPersRegCreateErrData)errResponse.getExtension(EPPPersRegCreateErrData.class);
                if (ext.getCode() == 1) {
                    System.out.println("persRegErrCreate: Corresponding Service Exists");
                } else if (ext.getCode() == 2) {
                    System.out.println("persRegErrCreate: Defensive Registration Exists");
                }
            }
            System.out.println("persRegErrCreate: Response has no extension");
        }
        this.printEnd("persRegErrCreate");
    }

    public void persRegRenew() {
        EPPPersRegRenewData ext;
        this.printStart("persRegRenew");
        try {
            System.out.println("\npersRegRenew: Domain Renew");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setExpirationDate(new GregorianCalendar(2004, 2, 3).getTime());
            this.domain.setPeriodLength(1);
            this.domain.setPeriodUnit("y");
            EPPDomainRenewResp domainResponse = this.domain.sendRenew();
            System.out.println("persRegRenew: Response = [" + domainResponse + "]\n\n");
            if (domainResponse.hasExtension(EPPPersRegRenewData.class)) {
                ext = (EPPPersRegRenewData)domainResponse.getExtension(EPPPersRegRenewData.class);
                System.out.println("persRegRenew: bundled rate = " + ext.isBundledRate());
            } else {
                System.out.println("persRegRenew: Response has no extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\npersRegRenew: EmailFwd Renew");
            this.email.setTransId("ABC-12345-XYZ");
            this.email.addEmailFwdName(this.makeEmail());
            this.email.setExpirationDate(new GregorianCalendar(2004, 2, 3).getTime());
            this.email.setPeriodLength(1);
            this.email.setPeriodUnit("y");
            EPPEmailFwdRenewResp emailResponse = this.email.sendRenew();
            System.out.println("persRegRenew: Response = [" + emailResponse + "]\n\n");
            if (emailResponse.hasExtension(EPPPersRegRenewData.class)) {
                ext = (EPPPersRegRenewData)emailResponse.getExtension(EPPPersRegRenewData.class);
                System.out.println("persRegRenew: bundled rate = " + ext.isBundledRate());
            } else {
                System.out.println("persRegRenew: Response has no extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("persRegRenew");
    }

    public void persRegTransfer() {
        EPPPersRegTransferData ext;
        this.printStart("persRegTransfer");
        try {
            System.out.println("\npersRegTransfer: Domain Transfer");
            this.domain.setTransferOpCode("request");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setAuthString("ClientX");
            this.domain.setPeriodLength(1);
            this.domain.setPeriodUnit("y");
            EPPDomainTransferResp domainResponse = this.domain.sendTransfer();
            System.out.println("persRegTransfer: Response = [" + domainResponse + "]\n\n");
            if (domainResponse.hasExtension(EPPPersRegTransferData.class)) {
                ext = (EPPPersRegTransferData)domainResponse.getExtension(EPPPersRegTransferData.class);
                System.out.println("persRegTransfer: bundled rate = " + ext.isBundledRate());
            } else {
                System.out.println("persRegTransfer: Response has no extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\npersRegTransfer: EmailFwd Transfer");
            this.email.setTransferOpCode("request");
            this.email.setTransId("ABC-12345-XYZ");
            this.email.addEmailFwdName(this.makeEmail());
            this.email.setAuthString("ClientX");
            this.email.setPeriodLength(1);
            this.email.setPeriodUnit("y");
            EPPEmailFwdTransferResp emailResponse = this.email.sendTransfer();
            System.out.println("persRegTransfer: Response = [" + emailResponse + "]\n\n");
            if (emailResponse.hasExtension(EPPPersRegTransferData.class)) {
                ext = (EPPPersRegTransferData)emailResponse.getExtension(EPPPersRegTransferData.class);
                System.out.println("persRegTransfer: bundled rate = " + ext.isBundledRate());
            } else {
                System.out.println("persRegTransfer: Response has no extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("persRegTransfer");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse domainResponse = this.session.getResponse();
            if (domainResponse != null && !domainResponse.isSuccess()) {
                Assert.fail((String)("Server Error : " + domainResponse));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse domainResponse = this.session.getResponse();
            if (domainResponse != null && !domainResponse.isSuccess()) {
                Assert.fail((String)("Server Error : " + domainResponse));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    @Before
    public void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
        this.email = new EPPEmailFwd(this.session);
    }

    @After
    public void tearDown() {
        this.endSession();
    }

    @BeforeClass
    public static void beforeClass() {
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
    }

    public void handleException(Exception aException) {
        EPPResponse domainResponse = this.session.getResponse();
        aException.printStackTrace();
        if (domainResponse != null && !domainResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + domainResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".second.name");
    }

    public String makeEmail() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + "@second.name");
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }
}

