/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckResult;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdContact;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdRenewResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdStatus;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferResp;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPEmailFwd;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.GregorianCalendar;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPEmailFwdTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPEmailFwdTst.class);
    private EPPEmailFwd emailFwd = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPEmailFwdTst(String name) {
        super(name);
    }

    public void testEmailFwd() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.emailFwdCheck();
            this.emailFwdInfo();
            this.emailFwdCreate();
            this.emailFwdDelete();
            this.emailFwdRenew();
            this.emailFwdUpdate();
            this.emailFwdTransferQuery();
            this.emailFwdTransfer();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    private void emailFwdCheck() {
        EPPEmailFwdCheckResult currResult;
        EPPEmailFwdCheckResp response;
        this.printStart("emailFwdCheck");
        try {
            int i;
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("emailFwdCheck: Check single emailFwd name (example.com)");
            this.emailFwd.setTransId("ABC-12345-XYZ");
            this.emailFwd.addEmailFwdName(this.makeEmailFwdName());
            response = this.emailFwd.sendCheck();
            System.out.println("Response Type = " + response.getType());
            System.out.println("Response.TransId.ServerTransId = " + response.getTransId().getServerTransId());
            System.out.println("Response.TransId.ServerTransId = " + response.getTransId().getClientTransId());
            System.out.println("\nemailFwdCheck: Response = [" + response + "]");
            for (i = 0; i < response.getCheckResults().size(); ++i) {
                currResult = (EPPEmailFwdCheckResult)response.getCheckResults().elementAt(i);
                if (currResult.isAvailable()) {
                    System.out.println("emailFwdCheck: EmailFwd " + currResult.getName() + " is available");
                    continue;
                }
                System.out.println("emailFwdCheck: EmailFwd " + currResult.getName() + " is unavailable");
            }
            for (i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        try {
            int i;
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("emailFwdCheck: Check multiple emailFwd names (example1.com, example2.com, example3.com)");
            this.emailFwd.setTransId("ABC-12345-XYZ");
            this.emailFwd.addEmailFwdName("ash@example1.com");
            this.emailFwd.addEmailFwdName("ash@example2.com");
            this.emailFwd.addEmailFwdName("ash@example3.com");
            for (i = 0; i <= 10; ++i) {
                this.emailFwd.addEmailFwdName(this.makeEmailFwdName());
            }
            response = this.emailFwd.sendCheck();
            System.out.println("\nemailFwdCheck: Response = [" + response + "]");
            System.out.println("Client Transaction Id = " + response.getTransId().getClientTransId());
            System.out.println("Server Transaction Id = " + response.getTransId().getServerTransId());
            for (i = 0; i < response.getCheckResults().size(); ++i) {
                currResult = (EPPEmailFwdCheckResult)response.getCheckResults().elementAt(i);
                if (currResult.isAvailable()) {
                    System.out.println("emailFwdCheck: EmailFwd " + currResult.getName() + " is available");
                    continue;
                }
                System.out.println("emailFwdCheck: EmailFwd " + currResult.getName() + " is unavailable");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("emailFwdCheck");
    }

    public void emailFwdInfo() {
        EPPEmailFwdInfoResp response;
        this.printStart("emailFwdInfo");
        try {
            int i;
            System.out.println("\nemailFwdInfo: EmailFwd info");
            this.emailFwd.setTransId("ABC-12345-XYZ");
            this.emailFwd.addEmailFwdName(this.makeEmailFwdName());
            response = this.emailFwd.sendInfo();
            System.out.println("emailFwdInfo: Response = [" + response + "]\n\n");
            System.out.println("emailFwdInfo: name            = " + response.getName());
            System.out.println("emailFwdInfo: client id       = " + response.getClientId());
            System.out.println("emailFwdInfo: created by      = " + response.getCreatedBy());
            System.out.println("emailFwdInfo: create date     = " + response.getCreatedDate());
            System.out.println("emailFwdInfo: expiration date = " + response.getExpirationDate());
            System.out.println("emailFwdInfo: Registrant      = " + response.getRegistrant());
            if (response.getContacts() != null) {
                for (i = 0; i < response.getContacts().size(); ++i) {
                    EPPEmailFwdContact myContact = (EPPEmailFwdContact)response.getContacts().elementAt(i);
                    System.out.println("Contact Name : " + myContact.getName());
                    System.out.println("Contact Type : " + myContact.getType());
                }
            }
            if (response.getAuthInfo() != null) {
                System.out.println("Authorization        : " + response.getAuthInfo().getPassword());
                System.out.println("Authorization (Roid) : " + response.getAuthInfo().getRoid());
            }
            if (response.getStatuses() != null) {
                for (i = 0; i < response.getStatuses().size(); ++i) {
                    EPPEmailFwdStatus myStatus = (EPPEmailFwdStatus)response.getStatuses().elementAt(i);
                    System.out.println("Lang     : " + myStatus.getLang());
                    System.out.println("Status   : " + myStatus.getStatus());
                }
            }
            for (i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\nemailFwdInfo: EmailFwd info");
            this.emailFwd.setTransId("ABC-12345-XYZ");
            this.emailFwd.addEmailFwdName(this.makeEmailFwdName());
            response = this.emailFwd.sendInfo();
            System.out.println("emailFwdInfo: Response = [" + response + "]\n\n");
            System.out.println("emailFwdInfo: name = " + response.getName());
            System.out.println("emailFwdInfo: client id = " + response.getClientId());
            System.out.println("emailFwdInfo: created by = " + response.getCreatedBy());
            System.out.println("emailFwdInfo: create date = " + response.getCreatedDate());
            System.out.println("emailFwdInfo: expiration date = " + response.getExpirationDate());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("emailFwdInfo");
    }

    public void emailFwdCreate() {
        EPPEmailFwdCreateResp response;
        this.printStart("emailFwdCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("emailFwdCreate: Create example.com with no optional attributes");
            this.emailFwd.setTransId("ABC-12345-XYZ");
            this.emailFwd.addEmailFwdName(this.makeEmailFwdName());
            this.emailFwd.setForwardTo("asampath@verisign.com");
            this.emailFwd.setAuthString("ClientX");
            response = this.emailFwd.sendCreate();
            System.out.println("emailFwdCreate: Response = [" + response + "]\n\n");
            System.out.println("emailFwdCreate: name = " + response.getName());
            System.out.println("emailFwdCreate: expiration date = " + response.getExpirationDate());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("emailFwdCreate: Create example.com with all optional attributes");
            this.emailFwd.setTransId("ABC-12345-XYZ");
            String myEmailFwdName = this.makeEmailFwdName();
            this.emailFwd.addEmailFwdName(myEmailFwdName);
            this.emailFwd.setForwardTo("asampath@verisign.com");
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.emailFwd.addContact("SH0000", "admin");
                this.emailFwd.addContact("SH0000", "tech");
                this.emailFwd.addContact("SH0000", "billing");
            }
            this.emailFwd.setPeriodLength(10);
            this.emailFwd.setPeriodUnit("y");
            this.emailFwd.setAuthString("ClientX");
            response = this.emailFwd.sendCreate();
            System.out.println("emailFwdCreate: Response = [" + response + "]\n\n");
            System.out.println("emailFwdCreate: name = " + response.getName());
            System.out.println("emailFwdCreate: expiration date = " + response.getExpirationDate());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("emailFwdCreate");
    }

    public void emailFwdDelete() {
        this.printStart("emailFwdDelete");
        try {
            System.out.println("\nemailFwdDelete: EmailFwd delete");
            this.emailFwd.setTransId("ABC-12345-XYZ");
            this.emailFwd.addEmailFwdName(this.makeEmailFwdName());
            EPPResponse response = this.emailFwd.sendDelete();
            System.out.println("emailFwdDelete: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("emailFwdDelete");
    }

    public void emailFwdRenew() {
        this.printStart("emailFwdRenew");
        try {
            System.out.println("\nemailFwdRenew: EmailFwd delete");
            this.emailFwd.setTransId("ABC-12345-XYZ");
            this.emailFwd.addEmailFwdName(this.makeEmailFwdName());
            this.emailFwd.setExpirationDate(new GregorianCalendar(2004, 2, 3).getTime());
            this.emailFwd.setPeriodLength(10);
            this.emailFwd.setPeriodUnit("y");
            EPPEmailFwdRenewResp response = this.emailFwd.sendRenew();
            System.out.println("emailFwdRenew: Response = [" + response + "]\n\n");
            System.out.println("emailFwdRenew: name = " + response.getName());
            System.out.println("emailFwdRenew: expiration date = " + response.getExpirationDate());
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("emailFwdRenew");
    }

    public void emailFwdUpdate() {
        this.printStart("emailFwdUpdate");
        try {
            System.out.println("\nemailFwdUpdate: EmailFwd update");
            this.emailFwd.setTransId("ABC-12345-XYZ");
            String myEmailFwdName = this.makeEmailFwdName();
            this.emailFwd.addEmailFwdName(myEmailFwdName);
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.emailFwd.setUpdateAttrib(1, "SH0000", "billing", 1);
            }
            this.emailFwd.setUpdateAttrib(2, new EPPEmailFwdStatus("clientHold"), 1);
            this.emailFwd.setUpdateAttrib(2, new EPPEmailFwdStatus("clientHold"), 2);
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.emailFwd.setUpdateAttrib(1, "SH0000", "billing", 2);
            }
            EPPResponse response = this.emailFwd.sendUpdate();
            System.out.println("emailFwdUpdate: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
            this.emailFwd.addEmailFwdName(myEmailFwdName);
            this.emailFwd.setForwardTo("hello@world.com");
            response = this.emailFwd.sendUpdate();
            System.out.println("emailFwdUpdate: Change forward to address Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("emailFwdUpdate");
    }

    public void emailFwdTransferQuery() {
        this.printStart("emailFwdTransferQuery");
        try {
            System.out.println("\nemailFwdTransferQuery: EmailFwd transfer query");
            this.emailFwd.setTransferOpCode("query");
            this.emailFwd.setTransId("ABC-12345-XYZ");
            this.emailFwd.addEmailFwdName(this.makeEmailFwdName());
            EPPEmailFwdTransferResp response = this.emailFwd.sendTransfer();
            System.out.println("emailFwdTransferQuery: Response = [" + response + "]\n\n");
            System.out.println("emailFwdTransferQuery: name = " + response.getName());
            System.out.println("emailFwdTransferQuery: request client = " + response.getRequestClient());
            System.out.println("emailFwdTransferQuery: action client = " + response.getActionClient());
            System.out.println("emailFwdTransferQuery: transfer status = " + response.getTransferStatus());
            System.out.println("emailFwdTransferQuery: request date = " + response.getRequestDate());
            System.out.println("emailFwdTransferQuery: action date = " + response.getActionDate());
            if (response.getExpirationDate() != null) {
                System.out.println("emailFwdTransferQuery: expiration date = " + response.getExpirationDate());
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("emailFwdTransferQuery");
    }

    public void emailFwdTransfer() {
        EPPEmailFwdTransferResp response;
        this.printStart("emailFwdTransfer");
        try {
            System.out.println("\nemailFwdTransfer: EmailFwd transfer request");
            this.emailFwd.setTransferOpCode("request");
            this.emailFwd.setTransId("ABC-12345-XYZ");
            this.emailFwd.setAuthString("ClientX");
            this.emailFwd.addEmailFwdName(this.makeEmailFwdName());
            this.emailFwd.setPeriodLength(10);
            this.emailFwd.setPeriodUnit("y");
            response = this.emailFwd.sendTransfer();
            System.out.println("emailFwdTransfer: Response = [" + response + "]\n\n");
            System.out.println("emailFwdTransfer: name = " + response.getName());
            System.out.println("emailFwdTransfer: request client = " + response.getRequestClient());
            System.out.println("emailFwdTransfer: action client = " + response.getActionClient());
            System.out.println("emailFwdTransfer: transfer status = " + response.getTransferStatus());
            System.out.println("emailFwdTransfer: request date = " + response.getRequestDate());
            System.out.println("emailFwdTransfer: action date = " + response.getActionDate());
            if (response.getExpirationDate() != null) {
                System.out.println("emailFwdTransfer: expiration date = " + response.getExpirationDate());
            }
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\nemailFwdTransfer: EmailFwd transfer cancel");
            this.emailFwd.setTransferOpCode("cancel");
            this.emailFwd.addEmailFwdName(this.makeEmailFwdName());
            response = this.emailFwd.sendTransfer();
            System.out.println("emailFwdTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\nemailFwdTransfer: EmailFwd transfer reject");
            this.emailFwd.setTransferOpCode("reject");
            this.emailFwd.addEmailFwdName(this.makeEmailFwdName());
            response = this.emailFwd.sendTransfer();
            System.out.println("emailFwdTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\nemailFwdTransfer: EmailFwd transfer approve");
            this.emailFwd.setTransferOpCode("approve");
            this.emailFwd.addEmailFwdName(this.makeEmailFwdName());
            response = this.emailFwd.sendTransfer();
            System.out.println("emailFwdTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("emailFwdTransfer");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.emailFwd = new EPPEmailFwd(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPEmailFwdTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPEmailFwdTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPEmailFwdTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeEmailFwdName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + "@verisign.com");
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }
}

