/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.allocationtoken.EPPAllocationToken;
import com.verisign.epp.codec.allocationtoken.EPPAllocationTokenInfo;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPAllocationTokenDomainTst {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPAllocationTokenDomainTst.class);
    private EPPDomain domain = null;
    private EPPSession session = null;
    private EPPClientCon connection = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    @Test
    public void testDomain() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.domainCheck();
            this.domainInfo();
            this.domainCreate();
            this.domainUpdate();
            this.domainTransfer();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    private void domainCheck() {
        this.printStart("domainCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainCheck: Check domain names example.tld and example2.tld with allocation token");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.tld");
            this.domain.addDomainName("example2.tld");
            this.domain.addExtension(new EPPAllocationToken("abc123"));
            EPPDomainCheckResp response = this.domain.sendCheck();
            System.out.println("Response Type = " + response.getType());
            System.out.println("Response.TransId.ServerTransId = " + response.getTransId().getServerTransId());
            System.out.println("Response.TransId.ServerTransId = " + response.getTransId().getClientTransId());
            System.out.println("\ndomainCheck: Response = [" + response + "]");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainCheck");
    }

    public void domainInfo() {
        this.printStart("domainInfo");
        try {
            System.out.println("\ndomainInfo: Domain info for example.tld with allocation token");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.tld");
            this.domain.addExtension(new EPPAllocationTokenInfo());
            EPPDomainInfoResp response = this.domain.sendInfo();
            System.out.println("domainInfo: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPAllocationToken.class)) {
                EPPAllocationToken theExt = (EPPAllocationToken)response.getExtension(EPPAllocationToken.class);
                System.out.println("domain:info: Response allocation token = " + theExt.getToken());
            } else {
                System.out.println("domainInfo: Response did not contain allocation token");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainInfo");
    }

    public void domainCreate() {
        this.printStart("domainCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainCreate: Create domain with allocation token");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setAuthString("ABC-12345");
            this.domain.addExtension(new EPPAllocationToken("abc123"));
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("domainCreate: Response = [" + response + "]\n\n");
            System.out.println("domainCreate: name = " + response.getName());
            System.out.println("domainCreate: expiration date = " + response.getExpirationDate());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainCreate");
    }

    public void domainTransfer() {
        this.printStart("domainTransfer");
        try {
            System.out.println("\ndomainTransfer: Domain transfer request of example1.tld with allocation token");
            this.domain.setTransferOpCode("request");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("2fooBAR");
            this.domain.addDomainName("example1.tld");
            this.domain.setPeriodLength(1);
            this.domain.setPeriodUnit("y");
            this.domain.addExtension(new EPPAllocationToken("abc123"));
            EPPDomainTransferResp response = this.domain.sendTransfer();
            System.out.println("domainTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainTransfer");
    }

    public void domainUpdate() {
        this.printStart("domainUpdate");
        try {
            System.out.println("\ndomainUpdate: Domain update of example1.tld with allocation token");
            this.domain.setTransId("ABC-12345-XYZ");
            String myDomainName = "example1.tld";
            this.domain.addDomainName(myDomainName);
            this.domain.addExtension(new EPPAllocationToken("abc123"));
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("domainUpdate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainUpdate");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
        this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    @Before
    public void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
    }

    @After
    public void tearDown() {
        this.endSession();
    }

    @BeforeClass
    public static void beforeClass() {
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }
}

