/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPComponentNotFoundException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPAssembler;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.pool.parser.EPPSchemaCachingParserPool;
import com.verisign.epp.pool.transformer.EPPTransformerPool;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPSendReceiveLogger;
import com.verisign.epp.util.EPPXMLStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class EPPXMLAssembler
implements EPPAssembler {
    private static Logger cat = LoggerFactory.getLogger(EPPXMLAssembler.class);
    private static boolean poolsInitialized = false;
    private EPPCodec codec = EPPCodec.getInstance();
    private EPPSendReceiveLogger sendReceiveLogger;

    public EPPXMLAssembler() {
        this.initXmlPools();
        this.sendReceiveLogger = EPPEnv.getSendReceiveLogger();
    }

    @Override
    public void toStream(EPPEventResponse aResponse, OutputStream aOutputStream, Object aData) throws EPPAssemblerException {
        cat.debug("toStream(EPPEventResponse, OutputStream): Enter");
        try {
            EPPMessage response = aResponse.getResponse();
            Document domDocument = this.codec.encode(response);
            EPPXMLStream xmlStream = new EPPXMLStream(EPPSchemaCachingParserPool.getInstance().getPool(), EPPTransformerPool.getInstance().getPool());
            xmlStream.write(domDocument, aOutputStream, response);
        }
        catch (EPPEncodeException e) {
            cat.error("toStream(EPPEventResponse, OutputStream)", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.MISSINGPARAMETER);
        }
        catch (EPPException e) {
            cat.error("toStream(EPPEventResponse, OutputStream)", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.FATAL);
        }
        cat.debug("toStream(EPPEventResponse, OutputStream): Return");
    }

    @Override
    public EPPEvent toEvent(InputStream aStream, Object aData) throws EPPAssemblerException {
        cat.debug("toEvent(InputStream): Enter");
        EPPMessage message = null;
        try {
            EPPXMLStream xmlStream = new EPPXMLStream(EPPSchemaCachingParserPool.getInstance().getPool(), EPPTransformerPool.getInstance().getPool());
            byte[] thePacket = xmlStream.readPacket(aStream);
            Document domDocument = xmlStream.decodePacket(thePacket);
            message = this.codec.decode(domDocument);
            this.sendReceiveLogger.logReceive(thePacket, message);
            if (aData != null && aData instanceof SessionData) {
                SessionData sessionData = (SessionData)aData;
                sessionData.setAttribute("PACKET", thePacket);
            }
        }
        catch (EPPComponentNotFoundException e) {
            cat.error("toEvent(InputStream):", (Throwable)e);
            switch (e.getKind()) {
                case 1: {
                    throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.COMMANDNOTFOUND);
                }
                case 3: {
                    throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.EXTENSIONNOTFOUND);
                }
                case 2: {
                    throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.RESPONSENOTFOUND);
                }
            }
        }
        catch (EPPDecodeException e) {
            cat.error("toEvent(InputStream):", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.MISSINGPARAMETER);
        }
        catch (EPPAssemblerException e) {
            cat.error("toEvent(InputStream):", (Throwable)e);
            throw e;
        }
        catch (EPPException e) {
            cat.error("toEvent(InputStream):", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.XML);
        }
        catch (InterruptedIOException e) {
            cat.debug("toEvent(InputStream):", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.INTRUPTEDIO);
        }
        catch (IOException e) {
            cat.error("toEvent(InputStream):", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.CLOSECON);
        }
        cat.debug("toEvent(InputStream): Return");
        return new EPPEvent(message);
    }

    private void initXmlPools() {
        if (!poolsInitialized) {
            EPPSchemaCachingParserPool.getInstance();
            EPPTransformerPool.getInstance();
            poolsInitialized = true;
        }
    }
}

