/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.defReg.EPPDefRegCheckCmd;
import com.verisign.epp.codec.defReg.EPPDefRegCreateCmd;
import com.verisign.epp.codec.defReg.EPPDefRegDeleteCmd;
import com.verisign.epp.codec.defReg.EPPDefRegInfoCmd;
import com.verisign.epp.codec.defReg.EPPDefRegMapFactory;
import com.verisign.epp.codec.defReg.EPPDefRegRenewCmd;
import com.verisign.epp.codec.defReg.EPPDefRegTransferCmd;
import com.verisign.epp.codec.defReg.EPPDefRegUpdateCmd;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EPPDefRegHandler
implements EPPEventHandler {
    private static final String NS = "http://www.nic.name/epp/defReg-1.0";
    private static Logger cat = LoggerFactory.getLogger(EPPDefRegHandler.class);

    public EPPDefRegHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPDefRegMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error("Couldn't load the Map Factory associated with the DefReg Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public final String getNamespace() {
        return NS;
    }

    @Override
    public final EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        EPPEventResponse response;
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        if (message instanceof EPPDefRegCreateCmd) {
            response = this.doDefRegCreate(aEvent, aData);
        } else if (message instanceof EPPDefRegDeleteCmd) {
            response = this.doDefRegDelete(aEvent, aData);
        } else if (message instanceof EPPDefRegInfoCmd) {
            response = this.doDefRegInfo(aEvent, aData);
        } else if (message instanceof EPPDefRegCheckCmd) {
            response = this.doDefRegCheck(aEvent, aData);
        } else if (message instanceof EPPDefRegRenewCmd) {
            response = this.doDefRegRenew(aEvent, aData);
        } else if (message instanceof EPPDefRegTransferCmd) {
            response = this.doDefRegTransfer(aEvent, aData);
        } else if (message instanceof EPPDefRegUpdateCmd) {
            response = this.doDefRegUpdate(aEvent, aData);
        } else {
            throw new EPPEventException("In EPPDefRegHandler an event was sent that is not supported");
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected abstract EPPEventResponse doDefRegCreate(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doDefRegDelete(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doDefRegInfo(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doDefRegCheck(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doDefRegRenew(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doDefRegTransfer(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doDefRegUpdate(EPPEvent var1, Object var2);
}

