/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.verificationcode;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPExtFactory;
import com.verisign.epp.codec.gen.EPPProtocolExtension;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCode;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeInfData;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeInfo;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPVerificationCodeExtFactory
extends EPPExtFactory {
    public static final String NS = "urn:ietf:params:xml:ns:verificationCode-1.0";
    public static final String NS_PREFIX = "verificationCode";
    private EPPService service = new EPPService("verificationCode", "urn:ietf:params:xml:ns:verificationCode-1.0");

    public EPPVerificationCodeExtFactory() {
        this.service.setServiceType(1);
    }

    @Override
    public EPPCodecComponent createExtension(Element aExtensionElm) throws EPPCodecException {
        String name = aExtensionElm.getLocalName();
        if (!aExtensionElm.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid extension type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("encodedSignedCode"))) {
            return new EPPEncodedSignedCode();
        }
        if (name.equals(EPPUtil.getLocalName("info"))) {
            return new EPPVerificationCodeInfo();
        }
        if (name.equals(EPPUtil.getLocalName("infData"))) {
            return new EPPVerificationCodeInfData();
        }
        throw new EPPCodecException("Invalid extension element " + name);
    }

    @Override
    public EPPProtocolExtension createProtocolExtension(Element aExtensionElm) throws EPPCodecException {
        throw new EPPCodecException("EPPVerificationCodeExtFactory.createProtocolExtension: Protocol extensions not supported");
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    public Set getXmlSchemas() {
        LinkedHashSet<String> theSchemas = new LinkedHashSet<String>();
        theSchemas.add("xmldsig-core-schema.xsd");
        theSchemas.add("verificationCode-1.0.xsd");
        return theSchemas;
    }
}

