/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.validate.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.validate.v02.EPPValidateAddress;
import com.verisign.epp.util.EqualityUtil;
import java.io.Serializable;
import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPValidatePostalDefinition
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPValidatePostalDefinition.class);
    public static final String ELM_LOCALNAME = "postalInfo";
    public static final String ELM_NAME = "validate:postalInfo";
    private static final String ELM_CONTACT_NAME = "name";
    private static final String ELM_ORG = "org";
    private static final String ATTR_TYPE = "type";
    private Type type = Type.INT;
    private String name = null;
    private String org = null;
    private EPPValidateAddress address = null;

    public EPPValidatePostalDefinition() {
    }

    public EPPValidatePostalDefinition(Type aType) {
        this.type = aType;
    }

    public EPPValidatePostalDefinition(Type aType, String aName, EPPValidateAddress aAddress) {
        this.name = aName;
        this.type = aType;
        this.address = aAddress;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type aType) {
        this.type = aType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean hasOrg() {
        return this.org != null;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String aOrg) {
        this.name = aOrg;
    }

    public EPPValidateAddress getAddress() {
        return this.address;
    }

    public void setAddress(EPPValidateAddress aAddress) {
        this.address = aAddress;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.type == null) {
            throw new EPPEncodeException("required attribute type is not set");
        }
        if (this.name == null) {
            throw new EPPEncodeException("required attribute name is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:validate-0.2", ELM_NAME);
        root.setAttribute(ATTR_TYPE, this.type.toString());
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:contact-1.0", "contact:name");
        EPPUtil.encodeString(aDocument, root, this.org, "urn:ietf:params:xml:ns:contact-1.0", "contact:org");
        EPPUtil.encodeComp(aDocument, root, this.address);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.type = Type.getType(aElement.getAttribute(ATTR_TYPE));
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_NAME);
        this.org = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_ORG);
        this.address = (EPPValidateAddress)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", "contact:addr", EPPValidateAddress.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPValidatePostalDefinition)) {
            return false;
        }
        EPPValidatePostalDefinition other = (EPPValidatePostalDefinition)aObject;
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error("EPPValidatePostalDefinition.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error("EPPValidatePostalDefinition.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.org, other.org)) {
            cat.error("EPPValidatePostalDefinition.equals(): org not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.address, other.address)) {
            cat.error("EPPValidatePostalDefinition.equals(): address not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPValidatePostalDefinition clone = (EPPValidatePostalDefinition)super.clone();
        if (this.address != null) {
            clone.address = (EPPValidateAddress)this.address.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:validate-0.2";
    }

    public static enum Type implements Serializable,
    Cloneable
    {
        LOC("loc"),
        INT("int");

        private final String typeStr;

        private Type(String aTypeStr) {
            this.typeStr = aTypeStr;
        }

        public static Type getType(String aType) {
            if (aType.equals(Type.LOC.typeStr)) {
                return LOC;
            }
            if (aType.equals(Type.INT.typeStr)) {
                return INT;
            }
            throw new InvalidParameterException("Type enum value of " + aType + " is not valid.");
        }

        public String toString() {
            return this.typeStr;
        }
    }
}

