/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.unhandlednamespaces.v1_0;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.unhandlednamespaces.v1_0.EPPUnhandledNamespacesMonitor;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPUnhandledNamespacesMonitorLogger
implements EPPUnhandledNamespacesMonitor {
    private static Logger cat = LoggerFactory.getLogger(EPPUnhandledNamespacesMonitorLogger.class);
    private Logger logger;
    private boolean useSuffix = false;

    public EPPUnhandledNamespacesMonitorLogger() {
    }

    public EPPUnhandledNamespacesMonitorLogger(Logger aLogger, boolean aUseSuffix) {
        this.logger = aLogger;
        this.useSuffix = aUseSuffix;
    }

    public boolean isUseSuffix() {
        return this.useSuffix;
    }

    public void setUseSuffix(boolean useSuffix) {
        this.useSuffix = useSuffix;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger aLogger) {
        this.logger = aLogger;
    }

    @Override
    public void monitorUnhandledNamespaces(EPPResponse aOrigResponse, EPPResponse aFilteredResponse, boolean aNoOp, Set<String> aUnhandledNamespaces, Object aData) {
        Logger theLogger = cat;
        if (this.logger != null) {
            theLogger = this.logger;
        }
        if (aNoOp) {
            theLogger.debug("No op = true, so response with unhandled namespaces is unfiltered");
        } else if (theLogger.isInfoEnabled()) {
            theLogger.info("Response with unhandled namespaces [" + aOrigResponse + "] filtered to [" + aFilteredResponse + "]");
        }
        if (aUnhandledNamespaces == null || aUnhandledNamespaces.isEmpty()) {
            return;
        }
        if (theLogger.isInfoEnabled()) {
            Object theMsg = "";
            boolean theFirst = true;
            for (String theNamespace : aUnhandledNamespaces) {
                if (theNamespace == null) continue;
                if (theFirst) {
                    theFirst = false;
                } else {
                    theMsg = (String)theMsg + ",";
                }
                if (this.useSuffix) {
                    theMsg = (String)theMsg + EPPUtil.namespaceToNamespaceSuffix(theNamespace);
                    continue;
                }
                theMsg = (String)theMsg + theNamespace;
            }
            theLogger.info("Unhandled namespaces = [" + (String)theMsg + "]");
        }
    }
}

