/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.unhandlednamespaces.v1_0;

import com.verisign.epp.codec.gen.EPPExtValue;
import com.verisign.epp.codec.gen.EPPResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPUnhandledNamespace {
    private static Logger cat = LoggerFactory.getLogger(EPPUnhandledNamespace.class);
    private static Pattern unhandledNamespacesPattern = Pattern.compile("^(.+) not in login services$");
    private String namespaceUri;
    private String xml;

    public EPPUnhandledNamespace() {
    }

    public EPPUnhandledNamespace(String aNamespaceUri, String aXml) {
        this.namespaceUri = aNamespaceUri;
        this.xml = aXml;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public void setNamespaceUri(String aNamespaceUri) {
        this.namespaceUri = aNamespaceUri;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String aXml) {
        this.xml = aXml;
    }

    public boolean fromEppExtValue(EPPExtValue aExtValue) {
        if (aExtValue == null) {
            return false;
        }
        Matcher theMatcher = unhandledNamespacesPattern.matcher(aExtValue.getReason());
        if (theMatcher.matches()) {
            this.namespaceUri = theMatcher.group(1);
            this.xml = aExtValue.getValueStr();
            return true;
        }
        return false;
    }

    public static List<EPPUnhandledNamespace> fromResponse(EPPResponse aResponse) {
        if (aResponse.getResult().getExtValues() == null) {
            return null;
        }
        ArrayList<EPPUnhandledNamespace> theUnhandledNamespaces = new ArrayList<EPPUnhandledNamespace>();
        Iterator<EPPExtValue> iterator = aResponse.getResult().getExtValues().iterator();
        while (iterator.hasNext()) {
            EPPUnhandledNamespace theUnhandledNamespace = new EPPUnhandledNamespace();
            EPPExtValue extValue = iterator.next();
            if (!theUnhandledNamespace.fromEppExtValue(extValue)) continue;
            theUnhandledNamespaces.add(theUnhandledNamespace);
        }
        if (theUnhandledNamespaces.size() != 0) {
            return theUnhandledNamespaces;
        }
        return null;
    }

    public String toString() {
        return "URI = " + this.namespaceUri + ", XML = [" + this.xml + "]";
    }

    public static void printUnhandledNamespaces(List<EPPUnhandledNamespace> aUnhandledNamespaces) {
        if (aUnhandledNamespaces == null || aUnhandledNamespaces.size() == 0) {
            System.out.println("printUnhandledNamespaces: There are no unhandled namespaces");
        }
        for (EPPUnhandledNamespace theUnhandledNamespace : aUnhandledNamespaces) {
            System.out.println(theUnhandledNamespace.toString());
        }
    }

    public static void logUnhandledNamespaces(List<EPPUnhandledNamespace> aUnhandledNamespaces) {
        if (aUnhandledNamespaces == null || aUnhandledNamespaces.size() == 0) {
            cat.debug("There are no unhandled namespaces");
        }
        for (EPPUnhandledNamespace theUnhandledNamespace : aUnhandledNamespaces) {
            cat.debug(theUnhandledNamespace.toString());
        }
    }
}

