/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.ttl.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.ttl.v1_0.EPPTtl;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EPPTtlExtension
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private String ELM_NAME = "ttl:" + this.getLocalName();
    private static Logger cat = LoggerFactory.getLogger(EPPTtlExtension.class);
    private List<EPPTtl> ttls = new ArrayList<EPPTtl>();

    protected abstract String getLocalName();

    public EPPTtlExtension() {
    }

    public EPPTtlExtension(EPPTtl aTtl) {
        this.addTtl(aTtl);
    }

    public EPPTtlExtension(List<EPPTtl> aTtls) {
        this.setTtls(aTtls);
    }

    public boolean hasTtls() {
        return !this.ttls.isEmpty();
    }

    public List<EPPTtl> getTtls() {
        return this.ttls;
    }

    public void addTtl(EPPTtl aTtl) {
        if (aTtl == null) {
            return;
        }
        this.ttls.add(aTtl);
    }

    public void setTtls(List<EPPTtl> aTtls) {
        this.ttls = aTtls == null ? new ArrayList<EPPTtl>() : aTtls;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPTtlExtension.encode(Document)");
        }
        if (this.ttls.isEmpty()) {
            throw new EPPEncodeException("At least one TTL is required in EPPTtlExtension.encode(Document).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:ttl-1.0", this.ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.ttls);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.ttls = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:ttl-1.0", "ttl", EPPTtl.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPTtlExtension clone = (EPPTtlExtension)super.clone();
        clone.ttls = new ArrayList<EPPTtl>();
        for (EPPTtl ttl : this.ttls) {
            clone.ttls.add((EPPTtl)ttl.clone());
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPTtlExtension)) {
            cat.error("EPPTtlExtension.equals(): " + aObject.getClass().getName() + " not EPPTtlExtension instance");
            return false;
        }
        EPPTtlExtension other = (EPPTtlExtension)aObject;
        if (!EqualityUtil.equals(this.ttls, other.ttls)) {
            cat.error("EPPTtlExtension.equals(): ttls not equal");
            return false;
        }
        return true;
    }
}

