/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.relateddomainext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRelatedDomainExtUpdate
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private static Logger cat = LoggerFactory.getLogger(EPPRelatedDomainExtUpdate.class);
    public static final String ELM_NAME = "relDom:update";
    public static final String ELM_DOMAIN_NAME = "relDom:name";
    private List<String> domainNames = null;

    public EPPRelatedDomainExtUpdate() {
    }

    public EPPRelatedDomainExtUpdate(List<String> aDomains) {
        this.domainNames = aDomains;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRelatedDomainExtUpdate theClone = new EPPRelatedDomainExtUpdate();
        if (this.domainNames != null) {
            theClone.domainNames = new ArrayList<String>();
            for (String domainName : this.domainNames) {
                if (domainName != null) {
                    theClone.domainNames.add(domainName);
                    continue;
                }
                theClone.domainNames.add(null);
            }
        } else {
            theClone.domainNames = null;
        }
        return theClone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.domainNames = EPPUtil.decodeList(aElement, "http://www.verisign.com/epp/relatedDomain-1.0", ELM_DOMAIN_NAME);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPRelatedDomainExtUpdate.decode: " + e);
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPRelatedDomainExtUpdate.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPRelatedDomainExtUpdate.encode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPRelatedDomainExtUpdate invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/relatedDomain-1.0", ELM_NAME);
        EPPUtil.encodeList(aDocument, root, this.domainNames, "http://www.verisign.com/epp/relatedDomain-1.0", ELM_DOMAIN_NAME);
        return root;
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof EPPRelatedDomainExtUpdate)) {
            return false;
        }
        EPPRelatedDomainExtUpdate theComp = (EPPRelatedDomainExtUpdate)aObj;
        if (!EPPUtil.equalLists(this.domainNames, theComp.domainNames)) {
            cat.error("EPPRelatedDomainExtUpdate.equals(): availableDomains not equal");
            return false;
        }
        return true;
    }

    public void addDomain(String aDomainName) {
        if (this.domainNames == null) {
            this.domainNames = new ArrayList<String>();
        }
        this.domainNames.add(aDomainName);
    }

    public boolean hasDomains() {
        return this.domainNames != null && this.domainNames.size() > 0;
    }

    public List<String> getDomains() {
        return this.domainNames;
    }

    public void setDomains(List<String> aDomains) {
        this.domainNames = aDomains;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/relatedDomain-1.0";
    }

    private void validateState() throws EPPCodecException {
        if (this.domainNames == null || this.domainNames.size() == 0) {
            throw new EPPCodecException("EPPRelatedDomainExtUpdate contains no elements.");
        }
        for (String domainName : this.domainNames) {
            if (domainName != null) continue;
            throw new EPPCodecException("EPPRelatedDomainExtUpdate: name element cannot be null.");
        }
    }
}

