/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.relateddomainext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomain;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRelatedDomainExtTransfer
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private static Logger cat = LoggerFactory.getLogger(EPPRelatedDomainExtTransfer.class);
    public static final String ELM_NAME = "relDom:transfer";
    private List<EPPRelatedDomainExtDomain> domains = null;

    public EPPRelatedDomainExtTransfer() {
    }

    public EPPRelatedDomainExtTransfer(List<EPPRelatedDomainExtDomain> aDomains) {
        this.domains = aDomains;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRelatedDomainExtTransfer theClone = new EPPRelatedDomainExtTransfer();
        if (this.domains != null) {
            theClone.domains = new ArrayList<EPPRelatedDomainExtDomain>();
            for (EPPRelatedDomainExtDomain domain : this.domains) {
                if (domain != null) {
                    theClone.domains.add((EPPRelatedDomainExtDomain)domain.clone());
                    continue;
                }
                theClone.domains.add(null);
            }
        } else {
            theClone.domains = null;
        }
        return theClone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.domains = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/relatedDomain-1.0", "relDom:domain", EPPRelatedDomainExtDomain.class);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPRelatedDomainExtTransfer.decode: " + e);
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPRelatedDomainExtTransfer.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPRelatedDomainExtTransfer.encode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPRelatedDomainExtTransfer invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/relatedDomain-1.0", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.domains);
        return root;
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof EPPRelatedDomainExtTransfer)) {
            return false;
        }
        EPPRelatedDomainExtTransfer theComp = (EPPRelatedDomainExtTransfer)aObj;
        if (!EPPUtil.equalLists(this.domains, theComp.domains)) {
            cat.error("EPPRelatedDomainExtTransfer.equals(): TransferDomains not equal");
            return false;
        }
        return true;
    }

    public void addDomain(EPPRelatedDomainExtDomain aDomain) {
        if (this.domains == null) {
            this.domains = new ArrayList<EPPRelatedDomainExtDomain>();
        }
        this.domains.add(aDomain);
    }

    public boolean hasDomains() {
        return this.domains != null && this.domains.size() > 0;
    }

    public List<EPPRelatedDomainExtDomain> getDomains() {
        return this.domains;
    }

    public void setDomains(List<EPPRelatedDomainExtDomain> aDomains) {
        this.domains = aDomains;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/relatedDomain-1.0";
    }

    private void validateState() throws EPPCodecException {
        if (this.domains == null || this.domains.size() == 0) {
            throw new EPPCodecException("EPPRelatedDomainExtRenew contains no  elements.");
        }
        for (EPPRelatedDomainExtDomain domain : this.domains) {
            if (domain == null) {
                throw new EPPCodecException("EPPRelatedDomainExtRenew: contains null EPPRelatedDomainExtDomain element.");
            }
            domain.validateStateForTransfer();
        }
    }
}

