/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.relateddomainext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtField;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRelatedDomainExtFields
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private static Logger cat = LoggerFactory.getLogger(EPPRelatedDomainExtFields.class);
    public static final String ELM_NAME = "relDom:fields";
    private static final String ELM_IN_SYNC_ATTR = "inSync";
    private List<EPPRelatedDomainExtField> fields = null;
    private boolean inSync;

    public EPPRelatedDomainExtFields() {
    }

    public EPPRelatedDomainExtFields(boolean aInSync) {
        this.inSync = aInSync;
    }

    public EPPRelatedDomainExtFields(List<EPPRelatedDomainExtField> aFields, boolean aInSync) {
        this.fields = aFields;
        this.inSync = aInSync;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRelatedDomainExtFields theClone = new EPPRelatedDomainExtFields();
        if (this.fields != null) {
            theClone.fields = new ArrayList<EPPRelatedDomainExtField>();
            for (EPPRelatedDomainExtField field : this.fields) {
                if (field != null) {
                    theClone.fields.add((EPPRelatedDomainExtField)field.clone());
                    continue;
                }
                theClone.fields.add(null);
            }
        } else {
            theClone.fields = null;
        }
        return theClone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.fields = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/relatedDomain-1.0", "relDom:field", EPPRelatedDomainExtField.class);
        this.inSync = EPPUtil.decodeBooleanAttr(aElement, ELM_IN_SYNC_ATTR);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPRelatedDomainExtFields.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPRelatedDomainExtFields.encode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPRelatedDomainExtFields invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/relatedDomain-1.0", ELM_NAME);
        String inSyncVal = this.inSync ? "true" : "false";
        root.setAttribute(ELM_IN_SYNC_ATTR, inSyncVal);
        EPPUtil.encodeCompList(aDocument, root, this.fields);
        return root;
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof EPPRelatedDomainExtFields)) {
            return false;
        }
        EPPRelatedDomainExtFields theComp = (EPPRelatedDomainExtFields)aObj;
        if (!EPPUtil.equalLists(this.fields, theComp.fields)) {
            cat.error("EPPRelatedDomainExtFields.equals(): fields not equal");
            return false;
        }
        return true;
    }

    public void addField(EPPRelatedDomainExtField aField) {
        if (this.fields == null) {
            this.fields = new ArrayList<EPPRelatedDomainExtField>();
        }
        this.fields.add(aField);
    }

    public boolean hasFields() {
        return this.fields != null && this.fields.size() > 0;
    }

    public List<EPPRelatedDomainExtField> getFields() {
        return this.fields;
    }

    public void setFields(List<EPPRelatedDomainExtField> fields) {
        this.fields = fields;
    }

    public boolean isInSync() {
        return this.inSync;
    }

    public void setInSync(boolean aInSync) {
        this.inSync = aInSync;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/relatedDomain-1.0";
    }

    private void validateState() throws EPPCodecException {
        if (this.fields == null || this.fields.size() == 0) {
            throw new EPPCodecException("EPPRelatedDomainExtFields contains no  elements.");
        }
    }
}

