/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPMapFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryCreateCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryCreateResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryDeleteCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryUpdateCmd;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPRegistryMapFactory
extends EPPMapFactory {
    public static final String NS = "urn:ietf:params:xml:ns:epp:registry-0.2";
    public static final String NS_PREFIX = "registry";
    private EPPService service = new EPPService("registry", "urn:ietf:params:xml:ns:epp:registry-0.2");

    @Override
    public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("registry:info"))) {
            return new EPPRegistryInfoCmd();
        }
        if (name.equals(EPPUtil.getLocalName("registry:check"))) {
            return new EPPRegistryCheckCmd();
        }
        if (name.equals(EPPUtil.getLocalName("registry:create"))) {
            return new EPPRegistryCreateCmd();
        }
        if (name.equals(EPPUtil.getLocalName("registry:update"))) {
            return new EPPRegistryUpdateCmd();
        }
        if (name.equals(EPPUtil.getLocalName("registry:delete"))) {
            return new EPPRegistryDeleteCmd();
        }
        throw new EPPCodecException("Invalid command element " + name);
    }

    @Override
    public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("registry:infData"))) {
            return new EPPRegistryInfoResp();
        }
        if (name.equals(EPPUtil.getLocalName("registry:chkData"))) {
            return new EPPRegistryCheckResp();
        }
        if (name.equals(EPPUtil.getLocalName("registry:creData"))) {
            return new EPPRegistryCreateResp();
        }
        throw new EPPCodecException("Invalid response element " + name);
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    public Set getXmlSchemas() {
        HashSet<String> theSchemas = new HashSet<String>();
        theSchemas.add("registry-0.2.xsd");
        return theSchemas;
    }
}

