/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryRegex;
import com.verisign.epp.codec.registry.v02.EPPRegistryReservedNames;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDomainName
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryDomainName.class);
    public static final String ELM_LOCALNAME = "domainName";
    public static final String ELM_NAME = "registry:domainName";
    static final String ELM_MIN_LENGTH = "minLength";
    static final String ELM_MAX_LENGTH = "maxLength";
    static final String ELM_ALPHA_NUM_START = "alphaNumStart";
    static final String ELM_ALPHA_NUM_END = "alphaNumEnd";
    static final String ELM_ALABEL_SUPPORTED = "aLabelSupported";
    static final String ELM_ULABEL_SUPPORTED = "uLabelSupported";
    static final String ELM_NAME_REGEX = "nameRegex";
    static final String ATTR_LEVEL = "level";
    private Integer level = null;
    private Integer minLength = null;
    private Integer maxLength = null;
    private Boolean alphaNumStart = Boolean.FALSE;
    private Boolean alphaNumEnd = Boolean.FALSE;
    private Boolean aLabelSupported = Boolean.TRUE;
    private Boolean uLabelSupported = Boolean.TRUE;
    private EPPRegistryRegex nameRegex = null;
    private EPPRegistryReservedNames reservedNames = null;

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryDomainName.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        root.setAttribute(ATTR_LEVEL, this.level.toString());
        if (this.minLength != null) {
            EPPUtil.encodeString(aDocument, root, this.minLength.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:minLength");
        }
        if (this.maxLength != null) {
            EPPUtil.encodeString(aDocument, root, this.maxLength.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:maxLength");
        }
        if (this.alphaNumStart == null) {
            this.alphaNumStart = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.alphaNumStart.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:alphaNumStart");
        if (this.alphaNumEnd == null) {
            this.alphaNumEnd = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.alphaNumEnd.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:alphaNumEnd");
        if (this.aLabelSupported == null) {
            this.aLabelSupported = Boolean.TRUE;
        }
        EPPUtil.encodeString(aDocument, root, this.aLabelSupported.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:aLabelSupported");
        if (this.uLabelSupported == null) {
            this.uLabelSupported = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.uLabelSupported.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:uLabelSupported");
        EPPUtil.encodeComp(aDocument, root, this.nameRegex);
        if (this.reservedNames != null) {
            EPPUtil.encodeComp(aDocument, root, this.reservedNames);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String levelStr = null;
        try {
            levelStr = aElement.getAttribute(ATTR_LEVEL);
            this.level = Integer.valueOf(levelStr);
        }
        catch (NumberFormatException e) {
            throw new EPPDecodeException("Cannot decode level: " + levelStr + "." + e);
        }
        this.minLength = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_MIN_LENGTH);
        this.maxLength = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_MAX_LENGTH);
        this.alphaNumStart = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_ALPHA_NUM_START);
        if (this.alphaNumStart == null) {
            this.alphaNumStart = Boolean.FALSE;
        }
        this.alphaNumEnd = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_ALPHA_NUM_END);
        if (this.alphaNumEnd == null) {
            this.alphaNumEnd = Boolean.FALSE;
        }
        this.aLabelSupported = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_ALABEL_SUPPORTED);
        if (this.aLabelSupported == null) {
            this.aLabelSupported = Boolean.TRUE;
        }
        this.setNameRegex((EPPRegistryRegex)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME_REGEX, EPPRegistryRegex.class));
        this.reservedNames = (EPPRegistryReservedNames)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:reservedNames", EPPRegistryReservedNames.class);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPRegistryDomainName.decode: " + e);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryDomainName)) {
            return false;
        }
        EPPRegistryDomainName theComp = (EPPRegistryDomainName)aObject;
        if (!EqualityUtil.equals(this.level, theComp.level)) {
            cat.error("EPPRegistryDomainName.equals(): level not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.minLength, theComp.minLength)) {
            cat.error("EPPRegistryDomainName.equals(): minLength not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maxLength, theComp.maxLength)) {
            cat.error("EPPRegistryDomainName.equals(): maxLength not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.alphaNumStart, theComp.alphaNumStart)) {
            cat.error("EPPRegistryDomainName.equals(): alphaNumStart not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.alphaNumEnd, theComp.alphaNumEnd)) {
            cat.error("EPPRegistryDomainName.equals(): alphaNumEnd not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.aLabelSupported, theComp.aLabelSupported)) {
            cat.error("EPPRegistryDomainName.equals(): aLabelSupported not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.uLabelSupported, theComp.uLabelSupported)) {
            cat.error("EPPRegistryDomainName.equals(): uLabelSupported not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.nameRegex, theComp.nameRegex)) {
            cat.error("EPPRegistryDomainName.equals(): nameRegex not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reservedNames, theComp.reservedNames)) {
            cat.error("EPPRegistryDomainName.equals(): reservedNames not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.level == null || this.level < 2) {
            throw new EPPCodecException("level should exist and be greater than or equal to 2");
        }
        if (this.minLength != null && this.minLength < 1) {
            throw new EPPCodecException("minLength, if specified, should be greater than 0");
        }
        if (this.maxLength != null) {
            if (this.minLength != null) {
                if (this.maxLength < this.minLength) {
                    throw new EPPCodecException("maxLength, if specified, should be no less than minLength");
                }
            } else if (this.maxLength < 1) {
                throw new EPPCodecException("maxLength, if specified, should be greater than 0");
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDomainName clone = (EPPRegistryDomainName)super.clone();
        if (this.reservedNames != null) {
            clone.reservedNames = (EPPRegistryReservedNames)this.reservedNames.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Boolean getAlphaNumStart() {
        return this.alphaNumStart;
    }

    public void setAlphaNumStart(Boolean alphaNumStart) {
        this.alphaNumStart = alphaNumStart;
    }

    public Boolean getAlphaNumEnd() {
        return this.alphaNumEnd;
    }

    public void setAlphaNumEnd(Boolean alphaNumEnd) {
        this.alphaNumEnd = alphaNumEnd;
    }

    public Boolean getALabelSupported() {
        return this.aLabelSupported;
    }

    public void setALabelSupported(Boolean aALabelSupported) {
        this.aLabelSupported = aALabelSupported;
    }

    public Boolean getULabelSupported() {
        return this.uLabelSupported;
    }

    public void setULabelSupported(Boolean aULabelSupported) {
        this.uLabelSupported = aULabelSupported;
    }

    public boolean hasNameRegex() {
        return this.nameRegex != null;
    }

    public EPPRegistryRegex getNameRegex() {
        return this.nameRegex;
    }

    public void setNameRegex(EPPRegistryRegex aNameRegex) {
        if (aNameRegex != null) {
            aNameRegex.setRootName(ELM_NAME_REGEX);
        }
        this.nameRegex = aNameRegex;
    }

    public EPPRegistryReservedNames getReservedNames() {
        return this.reservedNames;
    }

    public void setReservedNames(EPPRegistryReservedNames reservedNames) {
        this.reservedNames = reservedNames;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }
}

