/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCreateCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryZone;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryCreateCmd
extends EPPCreateCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryCreateCmd.class);
    public static final String ELM_LOCALNAME = "create";
    public static final String ELM_NAME = "registry:create";
    private EPPRegistryZone zone = null;

    public EPPRegistryCreateCmd() {
        this.zone = null;
    }

    public EPPRegistryCreateCmd(String aTransId, EPPRegistryZone aZone) {
        super(aTransId);
        this.zone = aZone;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    @Override
    public String getKey() {
        if (this.zone != null && this.zone.getName() != null) {
            return this.zone.getName().getName();
        }
        return null;
    }

    void validateState() throws EPPCodecException {
        if (this.zone == null) {
            throw new EPPCodecException("zone required element is not set");
        }
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryCreateCmd)) {
            cat.error("EPPRegistryCreateCmd.equals(): " + aObject.getClass().getName() + " not EPPRegistryCreateCmd instance");
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error("EPPRegistryCreateCmd.equals(): super class not equal");
            return false;
        }
        EPPRegistryCreateCmd theComp = (EPPRegistryCreateCmd)aObject;
        if (!EqualityUtil.equals(this.zone, theComp.zone)) {
            cat.error("EPPRegistryCreateCmd.equals(): zone not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryCreateCmd clone = (EPPRegistryCreateCmd)super.clone();
        if (this.zone != null) {
            clone.zone = (EPPRegistryZone)this.zone.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPRegistryCreateCmd.doEncode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPRegistryCreateCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.zone);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.zone = (EPPRegistryZone)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:zone", EPPRegistryZone.class);
    }

    public EPPRegistryZone getZone() {
        return this.zone;
    }

    public void setZone(EPPRegistryZone aZone) {
        this.zone = aZone;
    }
}

