/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUpdateCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryZoneInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryUpdateCmd
extends EPPUpdateCmd {
    private static final long serialVersionUID = -7884717270975504713L;
    static final String ELM_NAME = "registry:update";
    private EPPRegistryZoneInfo zone = null;
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryUpdateCmd.class);

    public EPPRegistryUpdateCmd() {
        this.zone = null;
    }

    public EPPRegistryUpdateCmd(String aTransId, EPPRegistryZoneInfo zone) {
        super(aTransId);
        this.zone = zone;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }

    @Override
    public String getKey() {
        if (this.zone != null) {
            return this.zone.getName();
        }
        return null;
    }

    void validateState() throws EPPCodecException {
        if (this.zone == null) {
            throw new EPPCodecException("zone required attribute is not set");
        }
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryUpdateCmd)) {
            cat.error("EPPRegistryUpdateCmd.equals(): " + aObject.getClass().getName() + " not EPPRegistryUpdateCmd instance");
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error("EPPRegistryUpdateCmd.equals(): super class not equal");
            return false;
        }
        EPPRegistryUpdateCmd theComp = (EPPRegistryUpdateCmd)aObject;
        if (!(this.zone != null ? this.zone.equals(theComp.zone) : theComp.zone == null)) {
            cat.error("EPPRegistryUpdateCmd.equals(): zone not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryUpdateCmd clone = (EPPRegistryUpdateCmd)super.clone();
        if (this.zone != null) {
            clone.zone = (EPPRegistryZoneInfo)this.zone.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPRegistryUpdateCmd.doEncode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPRegistryUpdateCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        root.setAttribute("xmlns:registry", "http://www.verisign.com/epp/registry-1.0");
        EPPUtil.encodeComp(aDocument, root, this.zone);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.zone = (EPPRegistryZoneInfo)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:zone", EPPRegistryZoneInfo.class);
    }

    public EPPRegistryZoneInfo getZone() {
        return this.zone;
    }

    public void setZone(EPPRegistryZoneInfo zone) {
        this.zone = zone;
    }
}

