/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistrySLA
implements EPPCodecComponent {
    private static final long serialVersionUID = 776401602842928568L;
    private static Logger cat = LoggerFactory.getLogger(EPPRegistrySLA.class);
    public static final String COMMAND_DOMAIN_CREATE = "domain:create";
    public static final String COMMAND_DOMAIN_UPDATE = "domain:update";
    public static final String COMMAND_DOMAIN_DELETE = "domain:delete";
    public static final String COMMAND_CONTACT_CREATE = "contact:create";
    public static final String COMMAND_CONTACT_DELETE = "contact:delete";
    public static final String COMMAND_CONTACT_UPDATE = "contact:update";
    public static final String COMMAND_NAMESERVER_CREATE = "nameserver:create";
    public static final String COMMAND_NAMESERVER_DELETE = "nameserver:delete";
    public static final String COMMAND_NAMESERVER_UPDATE = "nameserver:update";
    public static final String COMMAND_DOMAIN_CHECK = "domain:check";
    public static final String COMMAND_SUGGESTION_INFO = "suggestion:info";
    public static final String COMMAND_LOGIN = "login";
    public static final String COMMAND_LOGOUT = "logout";
    public static final String ELM_NAME = "registry:sla";
    public static final String ATTR_COMMAND = "command";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_SUBTYPE = "subtype";
    public static final String ATTR_UNIT = "unit";
    private BigDecimal value = null;
    private String type = null;
    private String subtype = null;
    private String command = null;
    private String unit = null;

    public EPPRegistrySLA() {
    }

    public EPPRegistrySLA(String type, String subtype, String command, BigDecimal value, String unit) {
        this.value = value;
        this.unit = unit;
        this.type = type;
        this.subtype = subtype;
        this.command = command;
    }

    public EPPRegistrySLA(String type, String subtype, String command, double value, String unit) {
        this(type, subtype, command, new BigDecimal(value), unit);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.type == null) {
            throw new EPPEncodeException("Invalid state on EPPRegistrySLA.encode: type is required");
        }
        if (this.value == null) {
            throw new EPPEncodeException("Invalid state on EPPRegistrySLA.encode: value is required");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        Text currVal = aDocument.createTextNode(this.value.toString());
        root.appendChild(currVal);
        root.setAttribute(ATTR_TYPE, this.type);
        if (this.command != null && this.command.trim().length() > 0) {
            root.setAttribute(ATTR_COMMAND, this.command);
        }
        if (this.unit != null && this.unit.trim().length() > 0) {
            root.setAttribute(ATTR_UNIT, this.unit);
        }
        if (this.subtype != null && this.subtype.trim().length() > 0) {
            root.setAttribute(ATTR_SUBTYPE, this.subtype);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.unit = aElement.getAttribute(ATTR_UNIT);
        this.command = aElement.getAttribute(ATTR_COMMAND);
        this.type = aElement.getAttribute(ATTR_TYPE);
        this.subtype = aElement.getAttribute(ATTR_SUBTYPE);
        this.value = new BigDecimal(aElement.getFirstChild().getNodeValue());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistrySLA)super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistrySLA)) {
            return false;
        }
        EPPRegistrySLA theComp = (EPPRegistrySLA)aObject;
        if (!(this.value != null ? this.value.equals(theComp.value) : theComp.value == null)) {
            cat.error("EPPRegistrySLA.equals(): value not equal");
            return false;
        }
        if (!(this.command != null ? this.command.equals(theComp.command) : theComp.command == null || theComp.command.trim().length() == 0)) {
            cat.error("EPPRegistrySLA.equals(): command not equal");
            return false;
        }
        if (!(this.type != null ? this.type.equals(theComp.type) : theComp.type == null || theComp.type.trim().length() == 0)) {
            cat.error("EPPRegistrySLA.equals(): type not equal");
            return false;
        }
        if (!(this.subtype != null ? this.subtype.equals(theComp.subtype) : theComp.subtype == null || theComp.subtype.trim().length() == 0)) {
            cat.error("EPPRegistrySLA.equals(): subtype not equal");
            return false;
        }
        if (!(this.unit != null ? this.unit.equals(theComp.unit) : theComp.unit == null || theComp.unit.trim().length() == 0)) {
            cat.error("EPPRegistrySLA.equals(): unit not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }

    public class Unit {
        public static final String UNIT_MILLISECOND = "ms";
        public static final String UNIT_PERCENTAGE = "percent";
    }
}

