/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryContactAddress;
import com.verisign.epp.codec.registry.EPPRegistryContactName;
import com.verisign.epp.codec.registry.EPPRegistryContactOrg;
import com.verisign.epp.codec.registry.EPPRegistryMinMaxLength;
import com.verisign.epp.codec.registry.EPPRegistryRegex;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryPostal
implements EPPCodecComponent {
    private static final long serialVersionUID = 7798346996535004684L;
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryPostal.class);
    public static final String ELM_LOCALNAME = "postalInfo";
    public static final String ELM_NAME = "registry:postalInfo";
    public static final String ELM_VOICE_REQUIRED = "voiceRequired";
    public static final String ELM_EMAIL_REGEX = "emailRegex";
    public static final String ELM_VOICE_EXT = "voiceExt";
    public static final String ELM_FAX_EXT = "faxExt";
    private EPPRegistryContactName name = null;
    private EPPRegistryContactOrg org = null;
    private EPPRegistryContactAddress address = null;
    private Boolean voiceRequired = Boolean.FALSE;
    private EPPRegistryMinMaxLength voiceExt = null;
    private EPPRegistryMinMaxLength faxExt = null;
    private List emailRegex = new ArrayList();

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryPostal.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.name);
        EPPUtil.encodeComp(aDocument, root, this.org);
        EPPUtil.encodeComp(aDocument, root, this.address);
        if (this.voiceRequired == null) {
            this.voiceRequired = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.voiceRequired.toString(), "http://www.verisign.com/epp/registry-1.0", "registry:voiceRequired");
        EPPUtil.encodeComp(aDocument, root, this.voiceExt);
        EPPUtil.encodeComp(aDocument, root, this.faxExt);
        if (this.emailRegex != null && this.emailRegex.size() > 0) {
            EPPUtil.encodeCompList(aDocument, root, this.emailRegex);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.setName((EPPRegistryContactName)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:name", EPPRegistryContactName.class));
        this.setOrg((EPPRegistryContactOrg)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:org", EPPRegistryContactOrg.class));
        this.address = (EPPRegistryContactAddress)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:address", EPPRegistryContactAddress.class);
        this.voiceRequired = EPPUtil.decodeBoolean(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_VOICE_REQUIRED);
        if (this.voiceRequired == null) {
            this.voiceRequired = Boolean.FALSE;
        }
        this.setVoiceExt((EPPRegistryMinMaxLength)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_VOICE_EXT, EPPRegistryMinMaxLength.class));
        this.setFaxExt((EPPRegistryMinMaxLength)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_FAX_EXT, EPPRegistryMinMaxLength.class));
        this.setEmailRegex(EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_EMAIL_REGEX, EPPRegistryRegex.class));
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required element is not set");
        }
        if (this.org == null) {
            throw new EPPCodecException("org required element is not set");
        }
        if (this.address == null) {
            throw new EPPCodecException("address required element is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryPostal clone = (EPPRegistryPostal)super.clone();
        if (this.name != null) {
            clone.name = (EPPRegistryContactName)this.name.clone();
        }
        if (this.org != null) {
            clone.org = (EPPRegistryContactOrg)this.org.clone();
        }
        if (this.address != null) {
            clone.address = (EPPRegistryContactAddress)this.address.clone();
        }
        if (this.voiceExt != null) {
            clone.voiceExt = (EPPRegistryMinMaxLength)this.voiceExt.clone();
        }
        if (this.faxExt != null) {
            clone.faxExt = (EPPRegistryMinMaxLength)this.faxExt.clone();
        }
        if (this.emailRegex != null) {
            clone.emailRegex = (List)((ArrayList)this.emailRegex).clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryPostal)) {
            return false;
        }
        EPPRegistryPostal theComp = (EPPRegistryPostal)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error("EPPRegistryPostal.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.org, theComp.org)) {
            cat.error("EPPRegistryPostal.equals(): org not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.address, theComp.address)) {
            cat.error("EPPRegistryPostal.equals(): address not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voiceRequired, theComp.voiceRequired)) {
            cat.error("EPPRegistryPostal.equals(): voiceRequired not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voiceExt, theComp.voiceExt)) {
            cat.error("EPPRegistryPostal.equals(): voiceExt not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.faxExt, theComp.faxExt)) {
            cat.error("EPPRegistryPostal.equals(): faxExt not equal");
            return false;
        }
        if (!(this.emailRegex != null ? EPPUtil.equalLists(this.emailRegex, theComp.emailRegex) : theComp.emailRegex == null)) {
            cat.error("EPPRegistryPostal.equals(): emailRegex not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryContactName getName() {
        return this.name;
    }

    public void setName(EPPRegistryContactName name) {
        this.name = name;
    }

    public EPPRegistryContactOrg getOrg() {
        return this.org;
    }

    public void setOrg(EPPRegistryContactOrg org) {
        this.org = org;
    }

    public EPPRegistryContactAddress getAddress() {
        return this.address;
    }

    public void setAddress(EPPRegistryContactAddress address) {
        this.address = address;
    }

    public Boolean getVoiceRequired() {
        return this.voiceRequired;
    }

    public void setVoiceRequired(Boolean voiceRequired) {
        this.voiceRequired = voiceRequired;
    }

    public EPPRegistryMinMaxLength getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(EPPRegistryMinMaxLength aVoiceExt) {
        if (aVoiceExt != null) {
            aVoiceExt.setRootName("registry:voiceExt");
        }
        this.voiceExt = aVoiceExt;
    }

    public EPPRegistryMinMaxLength getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(EPPRegistryMinMaxLength aFaxExt) {
        if (aFaxExt != null) {
            aFaxExt.setRootName("registry:faxExt");
        }
        this.faxExt = aFaxExt;
    }

    public List getEmailRegex() {
        return this.emailRegex;
    }

    public void addEmailRegex(EPPRegistryRegex re) {
        if (re != null) {
            re.setRootName(ELM_EMAIL_REGEX);
            if (this.emailRegex == null) {
                this.emailRegex = new ArrayList();
            }
            this.emailRegex.add(re);
        }
    }

    public void setEmailRegex(List emailRegex) {
        if (emailRegex != null) {
            for (EPPRegistryRegex re : emailRegex) {
                re.setRootName(ELM_EMAIL_REGEX);
            }
        }
        this.emailRegex = emailRegex;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }
}

