/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryCustomData;
import com.verisign.epp.codec.registry.EPPRegistryDNSSEC;
import com.verisign.epp.codec.registry.EPPRegistryDomainContact;
import com.verisign.epp.codec.registry.EPPRegistryDomainHostLimit;
import com.verisign.epp.codec.registry.EPPRegistryDomainNSLimit;
import com.verisign.epp.codec.registry.EPPRegistryDomainName;
import com.verisign.epp.codec.registry.EPPRegistryDomainPeriod;
import com.verisign.epp.codec.registry.EPPRegistryGracePeriod;
import com.verisign.epp.codec.registry.EPPRegistryIDN;
import com.verisign.epp.codec.registry.EPPRegistryRGP;
import com.verisign.epp.codec.registry.EPPRegistryRegex;
import com.verisign.epp.codec.registry.EPPRegistrySupportedStatus;
import com.verisign.epp.codec.registry.EPPRegistryTransferHoldPeriodType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDomain
implements EPPCodecComponent {
    private static final long serialVersionUID = 8674568245554756710L;
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryDomain.class);
    public static final String ELM_NAME = "registry:domain";
    public static final String ELM_PREMIUM_SUPPORT = "registry:premiumSupport";
    public static final String ELM_REGISTRANT = "registry:contactsSupported";
    @Deprecated
    public static final String ELM_URGENT = "registry:urgent";
    public static final String ELM_MAX_CHECK_DOMAIN = "registry:maxCheckDomain";
    public static final String ELM_AUTH_INFO_REGEX = "authInfoRegex";
    private List domainNames = new ArrayList();
    private EPPRegistryIDN idn = null;
    private Boolean premiumSupport = Boolean.FALSE;
    private Boolean contactsSupported = Boolean.TRUE;
    private List contacts = new ArrayList();
    private EPPRegistryDomainNSLimit nameServerLimit = null;
    private EPPRegistryDomainHostLimit childHostLimit = null;
    private List periods = new ArrayList();
    private EPPRegistryTransferHoldPeriodType transferHoldPeriod = null;
    private List gracePeriods = new ArrayList();
    private EPPRegistryRGP rgp = null;
    private EPPRegistryDNSSEC dnssec = null;
    private Integer maxCheckDomain = null;
    private EPPRegistrySupportedStatus supportedStatus = null;
    private EPPRegistryRegex authInfoRegex = null;
    private EPPRegistryCustomData customData = null;

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryDomain.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.domainNames);
        if (this.idn != null) {
            EPPUtil.encodeComp(aDocument, root, this.idn);
        }
        if (this.premiumSupport == null) {
            this.premiumSupport = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.premiumSupport.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_PREMIUM_SUPPORT);
        if (this.contactsSupported == null) {
            this.contactsSupported = Boolean.TRUE;
        }
        EPPUtil.encodeString(aDocument, root, this.contactsSupported.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_REGISTRANT);
        if (this.contacts != null && this.contacts.size() > 0) {
            EPPUtil.encodeCompList(aDocument, root, this.contacts);
        }
        EPPUtil.encodeComp(aDocument, root, this.nameServerLimit);
        EPPUtil.encodeComp(aDocument, root, this.childHostLimit);
        if (this.periods != null && this.periods.size() > 0) {
            EPPUtil.encodeCompList(aDocument, root, this.periods);
        }
        EPPUtil.encodeComp(aDocument, root, this.transferHoldPeriod);
        if (this.gracePeriods != null && this.gracePeriods.size() > 0) {
            EPPUtil.encodeCompList(aDocument, root, this.gracePeriods);
        }
        if (this.rgp != null) {
            EPPUtil.encodeComp(aDocument, root, this.rgp);
        }
        if (this.dnssec != null) {
            EPPUtil.encodeComp(aDocument, root, this.dnssec);
        }
        EPPUtil.encodeString(aDocument, root, this.maxCheckDomain.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_MAX_CHECK_DOMAIN);
        if (this.supportedStatus != null) {
            EPPUtil.encodeComp(aDocument, root, this.supportedStatus);
        }
        if (this.authInfoRegex != null) {
            EPPUtil.encodeComp(aDocument, root, this.authInfoRegex);
        }
        if (this.customData != null) {
            EPPUtil.encodeComp(aDocument, root, this.customData);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.domainNames = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:domainName", EPPRegistryDomainName.class);
        this.idn = (EPPRegistryIDN)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:idn", EPPRegistryIDN.class);
        this.premiumSupport = EPPUtil.decodeBoolean(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_PREMIUM_SUPPORT);
        if (this.premiumSupport == null) {
            this.premiumSupport = Boolean.FALSE;
        }
        this.contactsSupported = EPPUtil.decodeBoolean(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_REGISTRANT);
        if (this.contactsSupported == null) {
            this.contactsSupported = Boolean.TRUE;
        }
        this.contacts = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:contact", EPPRegistryDomainContact.class);
        this.nameServerLimit = (EPPRegistryDomainNSLimit)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:ns", EPPRegistryDomainNSLimit.class);
        this.childHostLimit = (EPPRegistryDomainHostLimit)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:childHost", EPPRegistryDomainHostLimit.class);
        this.periods = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:period", EPPRegistryDomainPeriod.class);
        this.transferHoldPeriod = (EPPRegistryTransferHoldPeriodType)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:transferHoldPeriod", EPPRegistryTransferHoldPeriodType.class);
        this.gracePeriods = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:gracePeriod", EPPRegistryGracePeriod.class);
        this.rgp = (EPPRegistryRGP)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:rgp", EPPRegistryRGP.class);
        this.dnssec = (EPPRegistryDNSSEC)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:dnssec", EPPRegistryDNSSEC.class);
        this.supportedStatus = (EPPRegistrySupportedStatus)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:supportedStatus", EPPRegistrySupportedStatus.class);
        this.maxCheckDomain = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_MAX_CHECK_DOMAIN);
        this.customData = (EPPRegistryCustomData)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:customData", EPPRegistryCustomData.class);
        this.setAuthInfoRegex((EPPRegistryRegex)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_AUTH_INFO_REGEX, EPPRegistryRegex.class));
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryDomain)) {
            return false;
        }
        EPPRegistryDomain theComp = (EPPRegistryDomain)aObject;
        if (!(this.domainNames != null ? EPPUtil.equalLists(this.domainNames, theComp.domainNames) : theComp.domainNames == null)) {
            cat.error("EPPRegistryDomain.equals(): domainNames not equal");
            return false;
        }
        if (!(this.premiumSupport != null ? this.premiumSupport.equals(theComp.premiumSupport) : theComp.premiumSupport == null)) {
            cat.error("EPPRegistryDomain.equals(): premiumSupport not equal");
            return false;
        }
        if (!(this.idn != null ? this.idn.equals(theComp.idn) : theComp.idn == null)) {
            cat.error("EPPRegistryDomain.equals(): idn not equal");
            return false;
        }
        if (!(this.contactsSupported != null ? this.contactsSupported.equals(theComp.contactsSupported) : theComp.contactsSupported == null)) {
            cat.error("EPPRegistryDomain.equals(): contactsSupported not equal");
            return false;
        }
        if (!(this.contacts != null ? EPPUtil.equalLists(this.contacts, theComp.contacts) : theComp.contacts == null)) {
            cat.error("EPPRegistryDomain.equals(): contacts not equal");
            return false;
        }
        if (!(this.nameServerLimit != null ? this.nameServerLimit.equals(theComp.nameServerLimit) : theComp.nameServerLimit == null)) {
            cat.error("EPPRegistryDomain.equals(): nameServerLimit not equal");
            return false;
        }
        if (!(this.childHostLimit != null ? this.childHostLimit.equals(theComp.childHostLimit) : theComp.childHostLimit == null)) {
            cat.error("EPPRegistryDomain.equals(): childHostLimit not equal");
            return false;
        }
        if (!(this.periods != null ? EPPUtil.equalLists(this.periods, theComp.periods) : theComp.periods == null)) {
            cat.error("EPPRegistryDomain.equals(): periods not equal");
            return false;
        }
        if (!(this.transferHoldPeriod != null ? this.transferHoldPeriod.equals(theComp.transferHoldPeriod) : theComp.transferHoldPeriod == null)) {
            cat.error("EPPRegistryDomain.equals(): transferHoldPeriod not equal");
            return false;
        }
        if (!(this.gracePeriods != null ? EPPUtil.equalLists(this.gracePeriods, theComp.gracePeriods) : theComp.gracePeriods == null)) {
            cat.error("EPPRegistryDomain.equals(): gracePeriods not equal");
            return false;
        }
        if (!(this.rgp != null ? this.rgp.equals(theComp.rgp) : theComp.rgp == null)) {
            cat.error("EPPRegistryDomain.equals(): rgp not equal");
            return false;
        }
        if (!(this.dnssec != null ? this.dnssec.equals(theComp.dnssec) : theComp.dnssec == null)) {
            cat.error("EPPRegistryDomain.equals(): dnssec not equal");
            return false;
        }
        if (!(this.maxCheckDomain != null ? this.maxCheckDomain.equals(theComp.maxCheckDomain) : theComp.maxCheckDomain == null)) {
            cat.error("EPPRegistryDomain.equals(): maxCheckDomain not equal");
            return false;
        }
        if (!(this.supportedStatus != null ? this.supportedStatus.equals(theComp.supportedStatus) : theComp.supportedStatus == null)) {
            cat.error("EPPRegistryDomain.equals(): supportedStatus not equal");
            return false;
        }
        if (!(this.authInfoRegex != null ? this.authInfoRegex.equals(theComp.authInfoRegex) : theComp.authInfoRegex == null)) {
            cat.error("EPPRegistryDomain.equals(): authInfoRegex not equal");
            return false;
        }
        if (!(this.customData != null ? this.customData.equals(theComp.customData) : theComp.customData == null)) {
            cat.error("EPPRegistryDomain.equals(): customData not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.domainNames == null || this.domainNames.size() == 0) {
            throw new EPPCodecException("domainNames element is not set");
        }
        if (this.contacts != null && this.contacts.size() > 3) {
            throw new EPPCodecException("number of contact element cannot exceed 3");
        }
        if (this.nameServerLimit == null) {
            throw new EPPCodecException("ns element is not set");
        }
        if (this.childHostLimit == null) {
            throw new EPPCodecException("childHost element is not set");
        }
        if (this.transferHoldPeriod == null) {
            throw new EPPCodecException("transferHoldPeriod element is not set");
        }
        if (this.maxCheckDomain == null || this.maxCheckDomain <= 0) {
            throw new EPPCodecException("maxCheckDomain is required and should be greater than 0");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDomain clone = (EPPRegistryDomain)super.clone();
        if (this.domainNames != null) {
            clone.domainNames = (List)((ArrayList)this.domainNames).clone();
        }
        if (this.idn != null) {
            clone.idn = (EPPRegistryIDN)this.idn.clone();
        }
        if (this.contacts != null) {
            clone.contacts = (List)((ArrayList)this.contacts).clone();
        }
        if (this.nameServerLimit != null) {
            clone.nameServerLimit = (EPPRegistryDomainNSLimit)this.nameServerLimit.clone();
        }
        if (this.childHostLimit != null) {
            clone.childHostLimit = (EPPRegistryDomainHostLimit)this.childHostLimit.clone();
        }
        if (this.periods != null) {
            clone.periods = (List)((ArrayList)this.periods).clone();
        }
        if (this.transferHoldPeriod != null) {
            clone.transferHoldPeriod = (EPPRegistryTransferHoldPeriodType)this.transferHoldPeriod.clone();
        }
        if (this.gracePeriods != null) {
            clone.gracePeriods = (List)((ArrayList)this.gracePeriods).clone();
        }
        if (this.rgp != null) {
            clone.rgp = (EPPRegistryRGP)this.rgp.clone();
        }
        if (this.dnssec != null) {
            clone.dnssec = (EPPRegistryDNSSEC)this.dnssec.clone();
        }
        if (this.supportedStatus != null) {
            clone.supportedStatus = (EPPRegistrySupportedStatus)this.supportedStatus.clone();
        }
        if (this.authInfoRegex != null) {
            clone.authInfoRegex = (EPPRegistryRegex)this.authInfoRegex.clone();
        }
        if (this.customData != null) {
            clone.customData = (EPPRegistryCustomData)this.customData.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public void addDomainName(EPPRegistryDomainName aDomainName) {
        if (this.domainNames == null) {
            this.domainNames = new ArrayList();
        }
        this.domainNames.add(aDomainName);
    }

    public List getDomainNames() {
        return this.domainNames;
    }

    public void setDomainNames(List domainNames) {
        this.domainNames = domainNames;
    }

    public EPPRegistryIDN getIdn() {
        return this.idn;
    }

    public void setIdn(EPPRegistryIDN idn) {
        this.idn = idn;
    }

    public Boolean getPremiumSupport() {
        return this.premiumSupport;
    }

    public void setPremiumSupport(Boolean premiumSupport) {
        this.premiumSupport = premiumSupport;
    }

    public Boolean getContactsSupported() {
        return this.contactsSupported;
    }

    public void setContactsSupported(Boolean contactsSupported) {
        this.contactsSupported = contactsSupported;
    }

    public List getContacts() {
        return this.contacts;
    }

    public void setContacts(List contacts) {
        this.contacts = contacts;
    }

    public void addContact(EPPRegistryDomainContact contact) {
        if (this.contacts == null) {
            this.contacts = new ArrayList();
        }
        this.contacts.add(contact);
    }

    public EPPRegistryDomainNSLimit getNameServerLimit() {
        return this.nameServerLimit;
    }

    public void setNameServerLimit(EPPRegistryDomainNSLimit nameServerLimit) {
        this.nameServerLimit = nameServerLimit;
    }

    public EPPRegistryDomainHostLimit getChildHostLimit() {
        return this.childHostLimit;
    }

    public void setChildHostLimit(EPPRegistryDomainHostLimit childHostLimit) {
        this.childHostLimit = childHostLimit;
    }

    public List getPeriods() {
        return this.periods;
    }

    public void setPeriods(List periods) {
        this.periods = periods;
    }

    public void addPeriod(EPPRegistryDomainPeriod period) {
        if (this.periods == null) {
            this.periods = new ArrayList();
        }
        this.periods.add(period);
    }

    public EPPRegistryTransferHoldPeriodType getTransferHoldPeriod() {
        return this.transferHoldPeriod;
    }

    public void setTransferHoldPeriod(EPPRegistryTransferHoldPeriodType transferHoldPeriod) {
        this.transferHoldPeriod = transferHoldPeriod;
    }

    public List getGracePeriods() {
        return this.gracePeriods;
    }

    public void setGracePeriods(List gracePeriods) {
        this.gracePeriods = gracePeriods;
    }

    public void addGracePeriod(EPPRegistryGracePeriod gracePeriod) {
        if (gracePeriod == null) {
            return;
        }
        if (this.gracePeriods == null) {
            this.gracePeriods = new ArrayList();
        }
        this.gracePeriods.add(gracePeriod);
    }

    public EPPRegistryRGP getRgp() {
        return this.rgp;
    }

    public void setRgp(EPPRegistryRGP rgp) {
        this.rgp = rgp;
    }

    public EPPRegistryDNSSEC getDnssec() {
        return this.dnssec;
    }

    public void setDnssec(EPPRegistryDNSSEC dnssec) {
        this.dnssec = dnssec;
    }

    public Integer getMaxCheckDomain() {
        return this.maxCheckDomain;
    }

    public void setMaxCheckDomain(Integer maxCheckDomain) {
        this.maxCheckDomain = maxCheckDomain;
    }

    public EPPRegistryCustomData getCustomData() {
        return this.customData;
    }

    public void setCustomData(EPPRegistryCustomData customData) {
        this.customData = customData;
    }

    public EPPRegistryRegex getAuthInfoRegex() {
        return this.authInfoRegex;
    }

    public void setAuthInfoRegex(EPPRegistryRegex authInfoRegex) {
        if (authInfoRegex != null) {
            authInfoRegex.setRootName(ELM_AUTH_INFO_REGEX);
        }
        this.authInfoRegex = authInfoRegex;
    }

    public EPPRegistrySupportedStatus getSupportedStatus() {
        return this.supportedStatus;
    }

    public void setSupportedStatus(EPPRegistrySupportedStatus supportedStatus) {
        this.supportedStatus = supportedStatus;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }
}

