/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.orgext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.orgext.EPPOrgExtId;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPOrgExtInfData
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPOrgExtInfData.class);
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "orgext:infData";
    private List<EPPOrgExtId> orgIds = new ArrayList<EPPOrgExtId>();

    public EPPOrgExtInfData() {
    }

    public EPPOrgExtInfData(EPPOrgExtId aOrgId) {
        this.addOrgId(aOrgId);
    }

    public EPPOrgExtInfData(List<EPPOrgExtId> aOrgIds) {
        this.setOrgIds(aOrgIds);
    }

    public boolean hasOrgIds() {
        return !this.orgIds.isEmpty();
    }

    public List<EPPOrgExtId> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(List<EPPOrgExtId> aOrgIds) {
        this.orgIds = aOrgIds == null ? new ArrayList<EPPOrgExtId>() : aOrgIds;
    }

    public void addOrgId(EPPOrgExtId aOrgId) {
        this.orgIds.add(aOrgId);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:orgext-1.0", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.orgIds);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.orgIds = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:orgext-1.0", "orgext:id", EPPOrgExtId.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgExtInfData clone = (EPPOrgExtInfData)super.clone();
        clone.orgIds = new ArrayList<EPPOrgExtId>(this.orgIds.size());
        for (EPPOrgExtId orgId : this.orgIds) {
            clone.orgIds.add((EPPOrgExtId)orgId.clone());
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgExtInfData)) {
            return false;
        }
        EPPOrgExtInfData other = (EPPOrgExtInfData)aObject;
        if (!EqualityUtil.equals(this.orgIds, other.orgIds)) {
            cat.error("EPPOrgExtInfData.equals(): orgIds not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:orgext-1.0";
    }
}

