/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUpdateCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.org.EPPOrgContact;
import com.verisign.epp.codec.org.EPPOrgPostalDefinition;
import com.verisign.epp.codec.org.EPPOrgRole;
import com.verisign.epp.codec.org.EPPOrgStatus;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPOrgUpdateCmd
extends EPPUpdateCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPOrgUpdateCmd.class);
    public static final String ELM_LOCALNAME = "update";
    public static final String ELM_NAME = "org:update";
    private static final String ELM_ADD = "add";
    private static final String ELM_STATUS = "status";
    private static final String ELM_REM = "rem";
    private static final String ELM_CHG = "chg";
    private static final String ELM_ORG_ID = "id";
    private static final String ELM_PARENT_ID = "parentId";
    private static final String ELM_VOICE = "voice";
    private static final String ELM_FAX = "fax";
    private static final String ELM_EMAIL = "email";
    private static final String ELM_URL = "url";
    private static final String ATTR_EXT = "x";
    private String orgId;
    private String parentId;
    private List<EPPOrgPostalDefinition> postalInfo = new ArrayList<EPPOrgPostalDefinition>();
    private String voice;
    private String voiceExt;
    private String fax;
    private String faxExt;
    private String email;
    private String url;
    private List<EPPOrgContact> addContacts = new ArrayList<EPPOrgContact>();
    private List<EPPOrgContact> remContacts = new ArrayList<EPPOrgContact>();
    private List<EPPOrgRole> addRoles = new ArrayList<EPPOrgRole>();
    private List<EPPOrgRole> remRoles = new ArrayList<EPPOrgRole>();
    private List<EPPOrgStatus> addStatuses = new ArrayList<EPPOrgStatus>();
    private List<EPPOrgStatus> remStatuses = new ArrayList<EPPOrgStatus>();

    public EPPOrgUpdateCmd() {
    }

    public EPPOrgUpdateCmd(String aTransId) {
        super(aTransId);
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String aOrgId) {
        this.orgId = aOrgId;
    }

    public boolean hasParentId() {
        return this.parentId != null;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String aParentId) {
        this.parentId = aParentId;
    }

    public boolean hasPostalInfo() {
        return this.postalInfo != null && !this.postalInfo.isEmpty();
    }

    public void addPostalInfo(EPPOrgPostalDefinition aPostalInfo) {
        this.postalInfo.add(aPostalInfo);
    }

    public List<EPPOrgPostalDefinition> getPostalInfo() {
        return this.postalInfo;
    }

    public void setPostalInfo(List<EPPOrgPostalDefinition> aPostalInfo) {
        this.postalInfo = aPostalInfo;
    }

    public boolean hasVoice() {
        return this.voice != null;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public boolean hasVoiceExt() {
        return this.voiceExt != null;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    public boolean hasFax() {
        return this.fax != null;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public boolean hasFaxExt() {
        return this.faxExt != null;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String aFaxExt) {
        this.faxExt = aFaxExt;
    }

    public boolean hasEmail() {
        return this.email != null;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String aUrl) {
        this.url = aUrl;
    }

    public boolean hasAddContacts() {
        return this.addContacts != null && !this.addContacts.isEmpty();
    }

    public void addAddContact(EPPOrgContact aContact) {
        this.addContacts.add(aContact);
    }

    public List<EPPOrgContact> getAddContacts() {
        return this.addContacts;
    }

    public void setAddContacts(List<EPPOrgContact> aContacts) {
        this.addContacts = aContacts;
    }

    public boolean hasRemContacts() {
        return this.remContacts != null && !this.remContacts.isEmpty();
    }

    public void addRemContact(EPPOrgContact aContact) {
        this.remContacts.add(aContact);
    }

    public List<EPPOrgContact> getRemContacts() {
        return this.remContacts;
    }

    public void setRemContacts(List<EPPOrgContact> aContacts) {
        this.remContacts = aContacts;
    }

    public boolean hasAddRoles() {
        return this.addRoles != null && !this.addRoles.isEmpty();
    }

    public void addAddRole(EPPOrgRole aRole) {
        this.addRoles.add(aRole);
    }

    public List<EPPOrgRole> getAddRoles() {
        return this.addRoles;
    }

    public void setAddRoles(List<EPPOrgRole> aRoles) {
        this.addRoles = aRoles;
    }

    public boolean hasRemRoles() {
        return this.remRoles != null && !this.remRoles.isEmpty();
    }

    public void addRemRole(EPPOrgRole aRole) {
        this.remRoles.add(aRole);
    }

    public List<EPPOrgRole> getRemRoles() {
        return this.remRoles;
    }

    public void setRemRoles(List<EPPOrgRole> aRoles) {
        this.remRoles = aRoles;
    }

    public boolean hasAddStatuses() {
        return this.addStatuses != null && !this.addStatuses.isEmpty();
    }

    public void addAddStatus(EPPOrgStatus aStatus) {
        this.addStatuses.add(aStatus);
    }

    public List<EPPOrgStatus> getAddStatuses() {
        return this.addStatuses;
    }

    public void setAddStatuses(List<EPPOrgStatus> aStatuses) {
        this.addStatuses = aStatuses;
    }

    public boolean hasRemStatuses() {
        return this.remStatuses != null && !this.remStatuses.isEmpty();
    }

    public void addRemStatus(EPPOrgStatus aStatus) {
        this.remStatuses.add(aStatus);
    }

    public List<EPPOrgStatus> getRemStatuses() {
        return this.remStatuses;
    }

    public void setRemStatuses(List<EPPOrgStatus> aStatuses) {
        this.remStatuses = aStatuses;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element theElm = null;
        Text theVal = null;
        if (this.orgId == null) {
            throw new EPPEncodeException("Undefined orgId in EPPOrgUpdateCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.orgId, "urn:ietf:params:xml:ns:epp:org-1.0", "org:id");
        if (this.hasAddContacts() || this.hasAddRoles() || this.hasAddStatuses()) {
            Element addElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", "org:add");
            EPPUtil.encodeCompList(aDocument, addElm, this.addContacts);
            EPPUtil.encodeCompList(aDocument, addElm, this.addRoles);
            EPPUtil.encodeList(aDocument, addElm, this.addStatuses, "urn:ietf:params:xml:ns:epp:org-1.0", "org:status");
            root.appendChild(addElm);
        }
        if (this.hasRemContacts() || this.hasRemRoles() || this.hasRemStatuses()) {
            Element remElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", "org:rem");
            EPPUtil.encodeCompList(aDocument, remElm, this.remContacts);
            EPPUtil.encodeCompList(aDocument, remElm, this.remRoles);
            EPPUtil.encodeList(aDocument, remElm, this.remStatuses, "urn:ietf:params:xml:ns:epp:org-1.0", "org:status");
            root.appendChild(remElm);
        }
        if (this.hasParentId() || this.hasPostalInfo() || this.hasVoice() || this.hasFax() || this.hasEmail() || this.hasUrl()) {
            Element chgElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", "org:chg");
            EPPUtil.encodeString(aDocument, chgElm, this.parentId, "urn:ietf:params:xml:ns:epp:org-1.0", "org:parentId");
            EPPUtil.encodeCompList(aDocument, chgElm, this.postalInfo);
            if (this.voice != null) {
                theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", "org:voice");
                theVal = aDocument.createTextNode(this.voice);
                theElm.appendChild(theVal);
                if (this.voiceExt != null) {
                    theElm.setAttribute(ATTR_EXT, this.voiceExt);
                }
                chgElm.appendChild(theElm);
            }
            if (this.fax != null) {
                theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", "org:fax");
                theVal = aDocument.createTextNode(this.fax);
                theElm.appendChild(theVal);
                if (this.faxExt != null) {
                    theElm.setAttribute(ATTR_EXT, this.faxExt);
                }
                chgElm.appendChild(theElm);
            }
            EPPUtil.encodeString(aDocument, chgElm, this.email, "urn:ietf:params:xml:ns:epp:org-1.0", "org:email");
            EPPUtil.encodeString(aDocument, chgElm, this.url, "urn:ietf:params:xml:ns:epp:org-1.0", "org:url");
            root.appendChild(chgElm);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theChgElm;
        Element theRemElm;
        Element theElm = null;
        this.orgId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_ORG_ID);
        Element theAddElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_ADD);
        if (theAddElm != null) {
            this.addContacts = EPPUtil.decodeCompList(theAddElm, "urn:ietf:params:xml:ns:epp:org-1.0", "org:contact", EPPOrgContact.class);
            this.addRoles = EPPUtil.decodeCompList(theAddElm, "urn:ietf:params:xml:ns:epp:org-1.0", "org:role", EPPOrgRole.class);
            this.addStatuses = EPPUtil.decodeEnumList(theAddElm, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_STATUS, EPPOrgStatus.class);
        }
        if ((theRemElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_REM)) != null) {
            this.remContacts = EPPUtil.decodeCompList(theRemElm, "urn:ietf:params:xml:ns:epp:org-1.0", "org:contact", EPPOrgContact.class);
            this.remRoles = EPPUtil.decodeCompList(theRemElm, "urn:ietf:params:xml:ns:epp:org-1.0", "org:role", EPPOrgRole.class);
            this.remStatuses = EPPUtil.decodeEnumList(theRemElm, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_STATUS, EPPOrgStatus.class);
        }
        if ((theChgElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_CHG)) != null) {
            this.parentId = EPPUtil.decodeString(theChgElm, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_PARENT_ID);
            this.postalInfo = EPPUtil.decodeCompList(theChgElm, "urn:ietf:params:xml:ns:epp:org-1.0", "org:postalInfo", EPPOrgPostalDefinition.class);
            theElm = EPPUtil.getElementByTagNameNS(theChgElm, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_VOICE);
            if (theElm != null) {
                this.voice = EPPUtil.getTextContent(theElm);
                this.voiceExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
            } else {
                this.voice = null;
                this.voiceExt = null;
            }
            theElm = EPPUtil.getElementByTagNameNS(theChgElm, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_FAX);
            if (theElm != null) {
                this.fax = EPPUtil.getTextContent(theElm);
                this.faxExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
            } else {
                this.fax = null;
                this.faxExt = null;
            }
            this.email = EPPUtil.decodeString(theChgElm, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_EMAIL);
            this.url = EPPUtil.decodeString(theChgElm, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_URL);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgUpdateCmd clone = (EPPOrgUpdateCmd)super.clone();
        if (this.hasPostalInfo()) {
            clone.postalInfo = (List)((ArrayList)this.postalInfo).clone();
        }
        if (this.hasAddContacts()) {
            clone.addContacts = (List)((ArrayList)this.addContacts).clone();
        }
        if (this.hasRemContacts()) {
            clone.remContacts = (List)((ArrayList)this.remContacts).clone();
        }
        if (this.hasAddRoles()) {
            clone.addRoles = (List)((ArrayList)this.addRoles).clone();
        }
        if (this.hasRemRoles()) {
            clone.remRoles = (List)((ArrayList)this.remRoles).clone();
        }
        if (this.hasAddStatuses()) {
            clone.addStatuses = (List)((ArrayList)this.addStatuses).clone();
        }
        if (this.hasRemStatuses()) {
            clone.remStatuses = (List)((ArrayList)this.remStatuses).clone();
        }
        return clone;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:org-1.0";
    }

    @Override
    public String getKey() {
        return this.getOrgId();
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgUpdateCmd)) {
            return false;
        }
        EPPOrgUpdateCmd other = (EPPOrgUpdateCmd)aObject;
        if (!EqualityUtil.equals(this.orgId, other.orgId)) {
            cat.error("EPPOrgUpdateCmd.equals(): orgId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.parentId, other.parentId)) {
            cat.error("EPPOrgUpdateCmd.equals(): parentId not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.postalInfo, other.postalInfo)) {
            cat.error("EPPOrgUpdateCmd.equals(): postalInfo not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voice, other.voice)) {
            cat.error("EPPOrgUpdateCmd.equals(): voice not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voiceExt, other.voiceExt)) {
            cat.error("EPPOrgUpdateCmd.equals(): voiceExt not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fax, other.fax)) {
            cat.error("EPPOrgUpdateCmd.equals(): fax not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.faxExt, other.faxExt)) {
            cat.error("EPPOrgUpdateCmd.equals(): faxExt not equal, this.faxExt = " + this.faxExt + ", other.faxExt = " + other.faxExt);
            return false;
        }
        if (!EqualityUtil.equals(this.email, other.email)) {
            cat.error("EPPOrgUpdateCmd.equals(): email not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.url, other.url)) {
            cat.error("EPPOrgUpdateCmd.equals(): url not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.addContacts, other.addContacts)) {
            cat.error("EPPOrgUpdateCmd.equals(): addContacts not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.remContacts, other.remContacts)) {
            cat.error("EPPOrgUpdateCmd.equals(): remContacts not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.addRoles, other.addRoles)) {
            cat.error("EPPOrgUpdateCmd.equals(): addRoles not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.remRoles, other.remRoles)) {
            cat.error("EPPOrgUpdateCmd.equals(): remRoles not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.addStatuses, other.addStatuses)) {
            cat.error("EPPOrgUpdateCmd.equals(): addStatuses not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.remStatuses, other.remStatuses)) {
            cat.error("EPPOrgUpdateCmd.equals(): remStatuses not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

