/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPInfoCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPOrgInfoCmd
extends EPPInfoCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPOrgInfoCmd.class);
    public static final String ELM_LOCALNAME = "info";
    public static final String ELM_NAME = "org:info";
    private static final String ELM_ORG_ID = "id";
    private String orgId;

    public EPPOrgInfoCmd() {
    }

    public EPPOrgInfoCmd(String aTransId) {
        super(aTransId);
    }

    public EPPOrgInfoCmd(String aTransId, String aOrgId) {
        super(aTransId);
        this.orgId = aOrgId;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:org-1.0";
    }

    @Override
    public String getKey() {
        return this.getOrgId();
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String aOrgId) {
        this.orgId = aOrgId;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.orgId == null) {
            throw new EPPEncodeException("Undefined orgId in EPPOrgInfoCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.orgId, "urn:ietf:params:xml:ns:epp:org-1.0", "org:id");
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.orgId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_ORG_ID);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgInfoCmd)) {
            return false;
        }
        EPPOrgInfoCmd other = (EPPOrgInfoCmd)aObject;
        if (!EqualityUtil.equals(this.orgId, other.orgId)) {
            cat.error("EPPOrgInfoCmd.equals(): orgId not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgInfoCmd clone = (EPPOrgInfoCmd)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

