/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.maintenance.v1_0;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceItem;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceListItem;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPMaintenanceInfoResp
extends EPPResponse {
    private static Logger cat = LoggerFactory.getLogger(EPPMaintenanceInfoResp.class);
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "maint:infData";
    private static final String ELM_ITEM = "item";
    private static final String ELM_MAINTENANCE_LIST = "list";
    private InfoType infoType = InfoType.list;
    private EPPMaintenanceItem maintenance;
    private List<EPPMaintenanceListItem> listItems = null;

    public EPPMaintenanceInfoResp() {
        this.setInfoType(InfoType.list);
    }

    public EPPMaintenanceInfoResp(EPPTransId aTransId) {
        super(aTransId);
        this.setInfoType(InfoType.list);
    }

    public EPPMaintenanceInfoResp(EPPTransId aTransId, EPPMaintenanceItem aMaintenance) {
        super(aTransId);
        this.setMaintenance(aMaintenance);
    }

    public EPPMaintenanceInfoResp(EPPTransId aTransId, List<EPPMaintenanceListItem> aListItems) {
        super(aTransId);
        this.setListItems(aListItems);
    }

    public InfoType getInfoType() {
        return this.infoType;
    }

    public void setInfoType(InfoType aInfoType) {
        this.infoType = aInfoType;
        if (this.infoType == InfoType.maintenance) {
            this.listItems = null;
        } else {
            this.maintenance = null;
            if (this.listItems == null) {
                this.listItems = new ArrayList<EPPMaintenanceListItem>();
            }
        }
    }

    public boolean hastMaintenance() {
        return this.maintenance != null;
    }

    public EPPMaintenanceItem getMaintenance() {
        return this.maintenance;
    }

    public void setMaintenance(EPPMaintenanceItem aMaintenance) {
        this.maintenance = aMaintenance;
        if (this.maintenance != null) {
            this.setInfoType(InfoType.maintenance);
        } else {
            this.setInfoType(InfoType.list);
        }
    }

    public boolean hasListItems() {
        return this.listItems != null && !this.listItems.isEmpty();
    }

    public void addListItem(EPPMaintenanceListItem aItem) {
        this.setInfoType(InfoType.list);
        this.listItems.add(aItem);
    }

    public List<EPPMaintenanceListItem> getListItems() {
        return this.listItems;
    }

    public void setListItems(List<EPPMaintenanceListItem> aListItmes) {
        this.listItems = aListItmes;
        if (this.listItems != null) {
            this.setInfoType(InfoType.list);
        } else {
            this.setInfoType(InfoType.maintenance);
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.infoType == InfoType.maintenance && this.maintenance == null) {
            throw new EPPEncodeException("Undefined maintence when infoType = maintenance in EPPMaintenanceInfoResp");
        }
        if (this.infoType == InfoType.list && this.listItems == null) {
            throw new EPPEncodeException("Undefined listItems when infoType = list in EPPMaintenanceInfoResp");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_NAME);
        if (this.infoType == InfoType.maintenance) {
            EPPUtil.encodeComp(aDocument, root, this.maintenance);
        } else {
            Element theTypeElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:list");
            root.appendChild(theTypeElm);
            EPPUtil.encodeCompList(aDocument, theTypeElm, this.listItems);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theTypeElm = EPPUtil.getFirstElementChild(aElement);
        if (theTypeElm == null) {
            throw new EPPDecodeException("Unable to find child element of maint:infData");
        }
        if (theTypeElm.getLocalName().equals(ELM_ITEM)) {
            this.setMaintenance((EPPMaintenanceItem)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_ITEM, EPPMaintenanceItem.class));
        } else if (theTypeElm.getLocalName().equals(ELM_MAINTENANCE_LIST)) {
            this.setListItems(EPPUtil.decodeCompList(theTypeElm, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "listItem", EPPMaintenanceListItem.class));
        } else {
            throw new EPPDecodeException("Unsupported to child element " + theTypeElm.getLocalName() + " of maint:infData");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPMaintenanceInfoResp clone = (EPPMaintenanceInfoResp)super.clone();
        if (this.infoType == InfoType.list) {
            clone.listItems = (List)((ArrayList)this.listItems).clone();
        }
        return clone;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:maintenance-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMaintenanceInfoResp)) {
            return false;
        }
        EPPMaintenanceInfoResp other = (EPPMaintenanceInfoResp)aObject;
        if (!EqualityUtil.equals(this.maintenance, other.maintenance)) {
            cat.error("EPPMaintenanceInfoResp.equals(): maintenance not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.listItems, other.listItems)) {
            cat.error("EPPMaintenanceInfoResp.equals(): listItems not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public static enum InfoType {
        list,
        maintenance;

    }
}

