/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.maintenance.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPMaintenanceDescription
implements EPPCodecComponent {
    public static final String DEFAULT_LANG = "en";
    private static Logger cat = LoggerFactory.getLogger(EPPMaintenanceDescription.class);
    public static final String ELM_LOCALNAME = "description";
    public static final String ELM_NAME = "maint:description";
    private static final String ATTR_LANG = "lang";
    private static final String ATTR_TYPE = "type";
    private String lang = "en";
    private Type type = Type.plain;
    private String description;

    public EPPMaintenanceDescription() {
    }

    public EPPMaintenanceDescription(String aDescription) {
        this.description = aDescription;
    }

    public EPPMaintenanceDescription(String aDescription, Type aType, String aLang) {
        this.description = aDescription;
        this.type = aType;
        this.lang = aLang;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    public boolean hasLang() {
        return !this.lang.equals(DEFAULT_LANG);
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang == null ? DEFAULT_LANG : aLang;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type aType) {
        this.type = aType == null ? Type.plain : aType;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.description == null || this.type == null || this.lang == null) {
            throw new EPPEncodeException("required attribute is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_NAME);
        Text currVal = aDocument.createTextNode(this.description);
        root.appendChild(currVal);
        root.setAttribute(ATTR_TYPE, this.type.toString());
        root.setAttribute(ATTR_LANG, this.lang);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.description = EPPUtil.decodeStringValue(aElement);
        this.setType(Type.valueOf(aElement.getAttribute(ATTR_TYPE)));
        this.setLang(EPPUtil.decodeStringAttr(aElement, ATTR_LANG));
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMaintenanceDescription)) {
            return false;
        }
        EPPMaintenanceDescription other = (EPPMaintenanceDescription)aObject;
        if (!EqualityUtil.equals(this.description, other.description)) {
            cat.error("EPPMaintenanceDescription.equals(): description not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.type, (Object)other.type)) {
            cat.error("EPPMaintenanceDescription.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lang, other.lang)) {
            cat.error("EPPMaintenanceDescription.equals(): lang not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPMaintenanceDescription clone = null;
        clone = (EPPMaintenanceDescription)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:maintenance-1.0";
    }

    public static enum Type {
        plain,
        html;

    }
}

