/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launchpolicy.v01;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyCreate;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyInfData;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyInfoPhase;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyPhase;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyPhaseStatus;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyPollPolicy;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyUpdate;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyZone;
import com.verisign.epp.codec.registry.v02.EPPRegistryCreateCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryServices;
import com.verisign.epp.codec.registry.v02.EPPRegistryServicesExt;
import com.verisign.epp.codec.registry.v02.EPPRegistryTst;
import com.verisign.epp.codec.registry.v02.EPPRegistryUpdateCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryZone;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneData;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.GregorianCalendar;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPLaunchPolicyTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPLaunchPolicyTst(String name) {
        super(name);
    }

    public void testRegistryInfoZoneInfo() {
        EPPCodecTst.printStart("testRegistryInfoZoneInfo");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPRegistryZone zoneInfo = EPPRegistryTst.createZone();
        EPPRegistryInfoResp theResponse = new EPPRegistryInfoResp(theTransId, new EPPRegistryZoneData(zoneInfo, true));
        EPPLaunchPolicyInfData launchPolicyExt = new EPPLaunchPolicyInfData(EPPLaunchPolicyTst.buildLaunchPolicyZone());
        theResponse.addExtension(launchPolicyExt);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryInfoZoneInfo");
    }

    public void testRegistryCreate() {
        EPPCodecTst.printStart("testRegistryCreate");
        EPPRegistryZone zone = EPPRegistryTst.createZone();
        zone.setName("newtld");
        EPPRegistryCreateCmd theCommand = null;
        theCommand = new EPPRegistryCreateCmd("ABC-12349", zone);
        EPPLaunchPolicyCreate launchPolicyExt = new EPPLaunchPolicyCreate(EPPLaunchPolicyTst.buildLaunchPolicyZone());
        theCommand.addExtension(launchPolicyExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testRegistryCreate");
    }

    public void testRegistryUpdate() {
        EPPCodecTst.printStart("testRegistryUpdate");
        EPPRegistryZone zone = new EPPRegistryZone();
        zone.setName("newtld");
        EPPRegistryUpdateCmd theCommand = null;
        theCommand = new EPPRegistryUpdateCmd("ABC-12349", zone);
        zone.setDomain(EPPRegistryTst.buildInfoDomain());
        zone.setHost(EPPRegistryTst.buildInfoHost(true));
        zone.setContact(EPPRegistryTst.buildContact());
        EPPRegistryServices services = new EPPRegistryServices();
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:epp:registry-0.2", Boolean.TRUE));
        EPPRegistryServicesExt svcExt = new EPPRegistryServicesExt();
        services.setExtension(svcExt);
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:epp:registry-0.2", Boolean.TRUE));
        zone.setServices(services);
        zone.setCreatedBy("crId");
        zone.setCreatedDate(new Date());
        EPPLaunchPolicyUpdate launchPolicyExt = new EPPLaunchPolicyUpdate(EPPLaunchPolicyTst.buildLaunchPolicyZone());
        theCommand.addExtension(launchPolicyExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testRegistryUpdate");
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPRegistryTst Thread " + i, EPPLaunchPolicyTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPLaunchPolicyTst.suite());
        }
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPLaunchPolicyTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.registry.v02.EPPRegistryMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    public static EPPLaunchPolicyZone buildLaunchPolicyZone() {
        EPPLaunchPolicyZone zone = new EPPLaunchPolicyZone();
        EPPLaunchPolicyPhase sunrise = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.sunrise, new GregorianCalendar(2017, 11, 1, 0, 0).getTime());
        sunrise.setMode(EPPLaunchPolicyPhase.Mode.pendingApplication);
        sunrise.setEndDate(new GregorianCalendar(2017, 12, 1, 0, 0).getTime());
        sunrise.setValidatePhase(true);
        sunrise.addValidatorId("tmch");
        sunrise.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.pendingAllocation));
        sunrise.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.allocated));
        sunrise.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.rejected));
        sunrise.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.custom, "test", null, "test status"));
        sunrise.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        sunrise.setMaxMarks(1);
        sunrise.addSignedMarkSupported("urn:ietf:params:xml:ns:signedMark-1.0");
        sunrise.addEncodedSignedMarkSupported("urn:ietf:params:xml:ns:signedMark-1.0");
        sunrise.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.sunrise));
        sunrise.addCreateForm(EPPLaunchPolicyPhase.CreateForm.sunrise);
        sunrise.setCreateValidateType(true);
        zone.addPhase(sunrise);
        EPPLaunchPolicyPhase lrp1 = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.claims, new GregorianCalendar(2017, 12, 1, 0, 0).getTime());
        lrp1.setName("lrp1");
        lrp1.setMode(EPPLaunchPolicyPhase.Mode.pendingRegistration);
        lrp1.setEndDate(new GregorianCalendar(2017, 12, 8, 0, 0).getTime());
        lrp1.setValidatePhase(true);
        lrp1.addValidatorId("tmch");
        lrp1.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.pendingValidation));
        lrp1.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.allocated));
        lrp1.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.rejected));
        lrp1.setPendingCreate(true);
        lrp1.addCheckForm(EPPLaunchPolicyPhase.CheckForm.claims);
        lrp1.addCheckForm(EPPLaunchPolicyPhase.CheckForm.availability);
        lrp1.addCheckForm(EPPLaunchPolicyPhase.CheckForm.trademark);
        lrp1.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        lrp1.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.sunrise));
        lrp1.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "lrp1"));
        lrp1.addCreateForm(EPPLaunchPolicyPhase.CreateForm.claims);
        lrp1.setCreateValidateType(true);
        zone.addPhase(lrp1);
        EPPLaunchPolicyPhase landrush = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.claims, new GregorianCalendar(2017, 12, 8, 0, 0).getTime());
        landrush.setName("landrush");
        landrush.setMode(EPPLaunchPolicyPhase.Mode.pendingApplication);
        landrush.setEndDate(new GregorianCalendar(2017, 12, 15, 0, 0).getTime());
        landrush.setValidatePhase(true);
        landrush.addValidatorId("tmch");
        landrush.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.pendingAllocation));
        landrush.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.allocated));
        landrush.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.rejected));
        landrush.setPendingCreate(true);
        landrush.setPollPolicy(new EPPLaunchPolicyPollPolicy(false, false, false));
        landrush.addCheckForm(EPPLaunchPolicyPhase.CheckForm.claims);
        landrush.addCheckForm(EPPLaunchPolicyPhase.CheckForm.availability);
        landrush.addCheckForm(EPPLaunchPolicyPhase.CheckForm.trademark);
        landrush.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        landrush.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.sunrise));
        landrush.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "lrp1"));
        landrush.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "landrush"));
        landrush.addCreateForm(EPPLaunchPolicyPhase.CreateForm.claims);
        landrush.setCreateValidateType(true);
        zone.addPhase(landrush);
        EPPLaunchPolicyPhase claims = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.claims, new GregorianCalendar(2017, 12, 15, 0, 0).getTime());
        claims.setName("open");
        claims.setMode(EPPLaunchPolicyPhase.Mode.fcfs);
        claims.setEndDate(new GregorianCalendar(2018, 2, 15, 0, 0).getTime());
        claims.setValidatePhase(true);
        claims.addValidatorId("tmch");
        claims.addCheckForm(EPPLaunchPolicyPhase.CheckForm.claims);
        claims.addCheckForm(EPPLaunchPolicyPhase.CheckForm.availability);
        claims.addCheckForm(EPPLaunchPolicyPhase.CheckForm.trademark);
        claims.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        claims.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "landrush"));
        claims.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "open"));
        claims.addCreateForm(EPPLaunchPolicyPhase.CreateForm.claims);
        claims.addCreateForm(EPPLaunchPolicyPhase.CreateForm.general);
        claims.setCreateValidateType(true);
        zone.addPhase(claims);
        EPPLaunchPolicyPhase lrp2 = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.custom, new GregorianCalendar(2018, 2, 15, 0, 0).getTime());
        lrp2.setName("lrp2");
        lrp2.setMode(EPPLaunchPolicyPhase.Mode.pendingRegistration);
        lrp2.setEndDate(new GregorianCalendar(2018, 3, 15, 0, 0).getTime());
        lrp2.setValidatePhase(true);
        lrp2.addValidatorId("lrp2-custom");
        lrp2.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.custom, "pendingInternalValidation"));
        lrp2.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.allocated));
        lrp2.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.rejected));
        lrp2.setPendingCreate(true);
        lrp2.setPollPolicy(new EPPLaunchPolicyPollPolicy(true, false, false));
        lrp2.addCheckForm(EPPLaunchPolicyPhase.CheckForm.claims);
        lrp2.addCheckForm(EPPLaunchPolicyPhase.CheckForm.availability);
        lrp2.addCheckForm(EPPLaunchPolicyPhase.CheckForm.trademark);
        lrp2.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        sunrise.setMaxMarks(1);
        sunrise.addSignedMarkSupported("http://www.example.com/epp/lrp2-custom-1.0");
        sunrise.addEncodedSignedMarkSupported("http://www.example.com/epp/lrp2-custom-1.0");
        lrp2.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "open"));
        lrp2.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.custom, "lrp2"));
        lrp2.addCreateForm(EPPLaunchPolicyPhase.CreateForm.sunrise);
        lrp2.addCreateForm(EPPLaunchPolicyPhase.CreateForm.general);
        lrp2.addCreateForm(EPPLaunchPolicyPhase.CreateForm.claims);
        lrp2.addCreateForm(EPPLaunchPolicyPhase.CreateForm.mixed);
        lrp2.setCreateValidateType(true);
        zone.addPhase(lrp2);
        EPPLaunchPolicyPhase open = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.open, new GregorianCalendar(2018, 3, 15, 0, 0).getTime());
        open.setValidatePhase(false);
        zone.addPhase(open);
        return zone;
    }
}

