/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launchpolicy.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyInfoPhase;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyPhaseStatus;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyPollPolicy;
import com.verisign.epp.util.EqualityUtil;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLaunchPolicyPhase
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPLaunchPolicyPhase.class);
    public static final String ELM_LOCALNAME = "phase";
    public static final String ELM_NAME = "lp:phase";
    private static final String ELM_START_DATE = "startDate";
    private static final String ELM_END_DATE = "endDate";
    private static final String ELM_VALIDATE_PHASE = "validatePhase";
    private static final String ELM_VALIDATOR_ID = "validatorId";
    private static final String ELM_PENDING_CREATE = "pendingCreate";
    private static final String ELM_MARK_VALIDATION = "markValidation";
    private static final String ELM_MAX_MARKS = "maxMarks";
    private static final String ELM_MARK_SUPPORTED = "markSupported";
    private static final String ELM_SIGNED_MARK_SUPPORTED = "signedMarkSupported";
    private static final String ELM_ENCODED_SIGNED_MARK_SUPPORTED = "encodedSignedMarkSupported";
    private static final String ELM_CHECK_FORM = "checkForm";
    private static final String ELM_CREATE_FORM = "createForm";
    private static final String ELM_CREATE_VALIDATE_TYPE = "createValidateType";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_MODE = "mode";
    private Phase phase;
    private String name;
    private Mode mode = Mode.fcfs;
    private Date startDate;
    private Date endDate;
    private Boolean validatePhase;
    private List<String> validatorIds = new ArrayList<String>();
    private List<EPPLaunchPolicyPhaseStatus> statuses = new ArrayList<EPPLaunchPolicyPhaseStatus>();
    private Boolean pendingCreate;
    private EPPLaunchPolicyPollPolicy pollPolicy;
    private List<MarkValidation> markValidations = new ArrayList<MarkValidation>();
    private Integer maxMarks;
    private List<String> marksSupported = new ArrayList<String>();
    private List<String> signedMarksSupported = new ArrayList<String>();
    private List<String> encodedSignedMarksSupported = new ArrayList<String>();
    private List<CheckForm> checkForms = new ArrayList<CheckForm>();
    private List<EPPLaunchPolicyInfoPhase> infoPhases = new ArrayList<EPPLaunchPolicyInfoPhase>();
    private List<CreateForm> createForms = new ArrayList<CreateForm>();
    private Boolean createValidateType;

    public EPPLaunchPolicyPhase() {
    }

    public EPPLaunchPolicyPhase(Phase aPhase, Date aStartDate) {
        this.phase = aPhase;
        this.startDate = aStartDate;
    }

    public EPPLaunchPolicyPhase(Phase aPhase, String aName, Mode aMode, Date aStartDate, Date aEndDate, Boolean aValidatePhase, List<String> aValidatorIds, List<EPPLaunchPolicyPhaseStatus> aStatuses, Boolean aPendingCreate, EPPLaunchPolicyPollPolicy aPollPolicy, List<MarkValidation> aMarkValidations, Integer aMaxMarks, List<String> aMarksSupported, List<String> aSignedMarksSupported, List<String> aEncodedSignedMarksSupported, List<CheckForm> aCheckForms, List<CreateForm> aCreateForms, Boolean aCreateValidateType) {
        this.phase = aPhase;
        this.name = aName;
        this.setMode(aMode);
        this.startDate = aStartDate;
        this.endDate = aEndDate;
        this.validatePhase = aValidatePhase;
        this.setValidatorIds(aValidatorIds);
        this.setStatuses(aStatuses);
        this.pendingCreate = aPendingCreate;
        this.pollPolicy = aPollPolicy;
        this.setMarkValidations(aMarkValidations);
        this.maxMarks = aMaxMarks;
        this.setMarksSupported(aMarksSupported);
        this.setSignedMarksSupported(aSignedMarksSupported);
        this.setEncodedSignedMarksSupported(aEncodedSignedMarksSupported);
        this.setCheckForms(aCheckForms);
        this.setCreateForms(aCreateForms);
        this.createValidateType = aCreateValidateType;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchPolicyPhase clone = null;
        clone = (EPPLaunchPolicyPhase)super.clone();
        if (this.validatorIds != null) {
            clone.validatorIds = (List)((ArrayList)this.validatorIds).clone();
        }
        if (this.statuses != null) {
            clone.statuses = (List)((ArrayList)this.statuses).clone();
        }
        if (this.markValidations != null) {
            clone.markValidations = (List)((ArrayList)this.markValidations).clone();
        }
        if (this.marksSupported != null) {
            clone.marksSupported = (List)((ArrayList)this.marksSupported).clone();
        }
        if (this.signedMarksSupported != null) {
            clone.signedMarksSupported = (List)((ArrayList)this.signedMarksSupported).clone();
        }
        if (this.encodedSignedMarksSupported != null) {
            clone.encodedSignedMarksSupported = (List)((ArrayList)this.encodedSignedMarksSupported).clone();
        }
        if (this.checkForms != null) {
            clone.checkForms = (List)((ArrayList)this.checkForms).clone();
        }
        if (this.infoPhases != null) {
            clone.infoPhases = (List)((ArrayList)this.infoPhases).clone();
        }
        if (this.createForms != null) {
            clone.createForms = (List)((ArrayList)this.createForms).clone();
        }
        return clone;
    }

    public void validateState() throws EPPCodecException {
        if (!this.hasPhase()) {
            throw new EPPCodecException("phase required attribute is not set");
        }
        if (!this.hasStartDate()) {
            throw new EPPCodecException("startDate required attribute is not set");
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPLaunchPolicyPhase.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error(this.getClass().getName() + ".encode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode(): " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_NAME);
        root.setAttribute(ATTR_TYPE, this.phase.toString());
        if (this.hasName()) {
            root.setAttribute(ATTR_NAME, this.name);
        }
        root.setAttribute(ATTR_MODE, this.mode.toString());
        EPPUtil.encodeTimeInstant(aDocument, root, this.startDate, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:startDate");
        EPPUtil.encodeTimeInstant(aDocument, root, this.endDate, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:endDate");
        EPPUtil.encodeBoolean(aDocument, root, this.validatePhase, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:validatePhase");
        EPPUtil.encodeList(aDocument, root, this.validatorIds, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:validatorId");
        EPPUtil.encodeCompList(aDocument, root, this.statuses);
        EPPUtil.encodeBoolean(aDocument, root, this.pendingCreate, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:pendingCreate");
        EPPUtil.encodeComp(aDocument, root, this.pollPolicy);
        EPPUtil.encodeList(aDocument, root, this.markValidations, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:markValidation");
        EPPUtil.encodeInteger(aDocument, root, this.maxMarks, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:maxMarks");
        EPPUtil.encodeList(aDocument, root, this.marksSupported, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:markSupported");
        EPPUtil.encodeList(aDocument, root, this.signedMarksSupported, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:signedMarkSupported");
        EPPUtil.encodeList(aDocument, root, this.encodedSignedMarksSupported, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:encodedSignedMarkSupported");
        EPPUtil.encodeList(aDocument, root, this.checkForms, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:checkForm");
        EPPUtil.encodeCompList(aDocument, root, this.infoPhases);
        EPPUtil.encodeList(aDocument, root, this.createForms, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:createForm");
        EPPUtil.encodeBoolean(aDocument, root, this.createValidateType, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:createValidateType");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.phase = Phase.valueOf(EPPUtil.decodeStringAttr(aElement, ATTR_TYPE));
        this.name = EPPUtil.decodeStringAttr(aElement, ATTR_NAME);
        String theModeStr = EPPUtil.decodeStringAttr(aElement, ATTR_MODE);
        this.mode = theModeStr == null ? Mode.fcfs : Mode.getMode(theModeStr);
        this.startDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_START_DATE);
        this.endDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_END_DATE);
        this.validatePhase = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_VALIDATE_PHASE);
        this.validatorIds = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_VALIDATOR_ID);
        this.statuses = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "status", EPPLaunchPolicyPhaseStatus.class);
        this.pendingCreate = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_PENDING_CREATE);
        this.pollPolicy = (EPPLaunchPolicyPollPolicy)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "pollPolicy", EPPLaunchPolicyPollPolicy.class);
        this.markValidations = EPPUtil.decodeEnumList(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_MARK_VALIDATION, MarkValidation.class);
        this.maxMarks = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_MAX_MARKS);
        this.marksSupported = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_MARK_SUPPORTED);
        this.signedMarksSupported = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_SIGNED_MARK_SUPPORTED);
        this.encodedSignedMarksSupported = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_ENCODED_SIGNED_MARK_SUPPORTED);
        this.checkForms = EPPUtil.decodeEnumList(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_CHECK_FORM, CheckForm.class);
        this.infoPhases = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "infoPhase", EPPLaunchPolicyInfoPhase.class);
        this.createForms = EPPUtil.decodeEnumList(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_CREATE_FORM, CreateForm.class);
        this.createValidateType = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_CREATE_VALIDATE_TYPE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchPolicyPhase)) {
            return false;
        }
        EPPLaunchPolicyPhase other = (EPPLaunchPolicyPhase)aObject;
        if (!EqualityUtil.equals((Object)this.phase, (Object)other.phase)) {
            cat.error("EPPLaunchPolicyPhase.equals(): phase not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error("EPPLaunchPolicyPhase.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.mode, (Object)other.mode)) {
            cat.error("EPPLaunchPolicyPhase.equals(): mode not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.startDate, other.startDate)) {
            cat.error("EPPLaunchPolicyPhase.equals(): startDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.endDate, other.endDate)) {
            cat.error("EPPLaunchPolicyPhase.equals(): endDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.validatePhase, other.validatePhase)) {
            cat.error("EPPLaunchPolicyPhase.equals(): validatePhase not equal");
            return false;
        }
        if (!(this.validatorIds != null ? EPPUtil.equalLists(this.validatorIds, other.validatorIds) : other.validatorIds == null)) {
            cat.error("EPPLaunchPolicyPhase.equals(): validatorIds not equal");
            return false;
        }
        if (!(this.statuses != null ? EPPUtil.equalLists(this.statuses, other.statuses) : other.statuses == null)) {
            cat.error("EPPLaunchPolicyPhase.equals(): statuses not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.pendingCreate, other.pendingCreate)) {
            cat.error("EPPLaunchPolicyPhase.equals(): pendingCreate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.pollPolicy, other.pollPolicy)) {
            cat.error("EPPLaunchPolicyPhase.equals(): pollPolicy not equal");
            return false;
        }
        if (!(this.markValidations != null ? EPPUtil.equalLists(this.markValidations, other.markValidations) : other.markValidations == null)) {
            cat.error("EPPLaunchPolicyPhase.equals(): markValidations not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maxMarks, other.maxMarks)) {
            cat.error("EPPLaunchPolicyPhase.equals(): maxMarks not equal");
            return false;
        }
        if (!(this.marksSupported != null ? EPPUtil.equalLists(this.marksSupported, other.marksSupported) : other.marksSupported == null)) {
            cat.error("EPPLaunchPolicyPhase.equals(): marksSupported not equal");
            return false;
        }
        if (!(this.signedMarksSupported != null ? EPPUtil.equalLists(this.signedMarksSupported, other.signedMarksSupported) : other.signedMarksSupported == null)) {
            cat.error("EPPLaunchPolicyPhase.equals(): signedMarksSupported not equal");
            return false;
        }
        if (!(this.encodedSignedMarksSupported != null ? EPPUtil.equalLists(this.encodedSignedMarksSupported, other.encodedSignedMarksSupported) : other.encodedSignedMarksSupported == null)) {
            cat.error("EPPLaunchPolicyPhase.equals(): encodedSignedMarksSupported not equal");
            return false;
        }
        if (!(this.checkForms != null ? EPPUtil.equalLists(this.checkForms, other.checkForms) : other.checkForms == null)) {
            cat.error("EPPLaunchPolicyPhase.equals(): checkForms not equal");
            return false;
        }
        if (!(this.infoPhases != null ? EPPUtil.equalLists(this.infoPhases, other.infoPhases) : other.infoPhases == null)) {
            cat.error("EPPLaunchPolicyPhase.equals(): infoPhases not equal");
            return false;
        }
        if (!(this.createForms != null ? EPPUtil.equalLists(this.createForms, other.createForms) : other.createForms == null)) {
            cat.error("EPPLaunchPolicyPhase.equals(): createForms not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createValidateType, other.createValidateType)) {
            cat.error("EPPLaunchPolicyPhase.equals(): createValidateType not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:launchPolicy-0.1";
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public void setPhase(Phase aPhase) {
        this.phase = aPhase;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode aMode) {
        this.mode = aMode == null ? Mode.fcfs : aMode;
    }

    public boolean hasStartDate() {
        return this.startDate != null;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setCreateDate(Date aStartDate) {
        this.startDate = aStartDate;
    }

    public boolean hasEndDate() {
        return this.endDate != null;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date aEndDate) {
        this.endDate = aEndDate;
    }

    public boolean hasValidatePhase() {
        return this.validatePhase != null;
    }

    public Boolean getValidatePhase() {
        return this.validatePhase;
    }

    public void setValidatePhase(Boolean aValidatePhase) {
        this.validatePhase = aValidatePhase;
    }

    public boolean hasValidatorIds() {
        return this.validatorIds != null && !this.validatorIds.isEmpty();
    }

    public List<String> getValidatorIds() {
        return this.validatorIds;
    }

    public void setValidatorIds(List<String> aValidatorIds) {
        this.validatorIds = aValidatorIds == null ? new ArrayList<String>() : aValidatorIds;
    }

    public void addValidatorId(String aValidatorId) {
        if (aValidatorId == null) {
            this.validatorIds = new ArrayList<String>();
        }
        this.validatorIds.add(aValidatorId);
    }

    public boolean hasStatuses() {
        return this.statuses != null && !this.statuses.isEmpty();
    }

    public List<EPPLaunchPolicyPhaseStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<EPPLaunchPolicyPhaseStatus> aStatuses) {
        this.statuses = aStatuses == null ? new ArrayList<EPPLaunchPolicyPhaseStatus>() : aStatuses;
    }

    public void addStatus(EPPLaunchPolicyPhaseStatus aStatus) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<EPPLaunchPolicyPhaseStatus>();
        }
        this.statuses.add(aStatus);
    }

    public boolean hasPendingCreate() {
        return this.pendingCreate != null;
    }

    public Boolean getPendingCreate() {
        return this.pendingCreate;
    }

    public void setPendingCreate(Boolean aPendingCreate) {
        this.pendingCreate = aPendingCreate;
    }

    public boolean hasPollPolicy() {
        return this.pollPolicy != null;
    }

    public EPPLaunchPolicyPollPolicy getPollPolicy() {
        return this.pollPolicy;
    }

    public void setPollPolicy(EPPLaunchPolicyPollPolicy aPollPolicy) {
        this.pollPolicy = aPollPolicy;
    }

    public boolean hasMarkValidations() {
        return this.markValidations != null && !this.markValidations.isEmpty();
    }

    public List<MarkValidation> getMarkValidations() {
        return this.markValidations;
    }

    public void setMarkValidations(List<MarkValidation> aMarkValidations) {
        this.markValidations = aMarkValidations == null ? new ArrayList<MarkValidation>() : aMarkValidations;
    }

    public void addMarkValidation(MarkValidation aMarkValidation) {
        if (this.markValidations == null) {
            this.markValidations = new ArrayList<MarkValidation>();
        }
        this.markValidations.add(aMarkValidation);
    }

    public boolean hasMaxMarks() {
        return this.maxMarks != null;
    }

    public Integer getMaxMarks() {
        return this.maxMarks;
    }

    public void setMaxMarks(Integer aMaxMarks) {
        this.maxMarks = aMaxMarks;
    }

    public boolean hasMarksSupported() {
        return this.marksSupported != null && !this.marksSupported.isEmpty();
    }

    public List<String> getMarksSupported() {
        return this.marksSupported;
    }

    public void setMarksSupported(List<String> aMarksSupported) {
        this.marksSupported = aMarksSupported == null ? new ArrayList<String>() : aMarksSupported;
    }

    public void addMarkSupported(String aMarkSupported) {
        if (this.marksSupported == null) {
            this.marksSupported = new ArrayList<String>();
        }
        this.marksSupported.add(aMarkSupported);
    }

    public boolean hasSignedMarksSupported() {
        return this.signedMarksSupported != null && !this.signedMarksSupported.isEmpty();
    }

    public List<String> getSignedMarksSupported() {
        return this.signedMarksSupported;
    }

    public void setSignedMarksSupported(List<String> aSignedMarksSupported) {
        this.signedMarksSupported = aSignedMarksSupported == null ? new ArrayList<String>() : aSignedMarksSupported;
    }

    public void addSignedMarkSupported(String aSignedMarkSupported) {
        if (this.signedMarksSupported == null) {
            this.signedMarksSupported = new ArrayList<String>();
        }
        this.signedMarksSupported.add(aSignedMarkSupported);
    }

    public boolean hasEncodedSignedMarksSupported() {
        return this.encodedSignedMarksSupported != null && !this.encodedSignedMarksSupported.isEmpty();
    }

    public List<String> getEncodedSignedMarksSupported() {
        return this.encodedSignedMarksSupported;
    }

    public void setEncodedSignedMarksSupported(List<String> aEncodedSignedMarksSupported) {
        this.encodedSignedMarksSupported = aEncodedSignedMarksSupported == null ? new ArrayList<String>() : aEncodedSignedMarksSupported;
    }

    public void addEncodedSignedMarkSupported(String aEncodedSignedMarkSupported) {
        if (this.encodedSignedMarksSupported == null) {
            this.encodedSignedMarksSupported = new ArrayList<String>();
        }
        this.encodedSignedMarksSupported.add(aEncodedSignedMarkSupported);
    }

    public boolean hasCheckForms() {
        return this.checkForms != null && !this.checkForms.isEmpty();
    }

    public List<CheckForm> getCheckForms() {
        return this.checkForms;
    }

    public void setCheckForms(List<CheckForm> aCheckForms) {
        this.checkForms = aCheckForms == null ? new ArrayList<CheckForm>() : aCheckForms;
    }

    public void addCheckForm(CheckForm aCheckForm) {
        if (this.checkForms == null) {
            this.checkForms = new ArrayList<CheckForm>();
        }
        this.checkForms.add(aCheckForm);
    }

    public boolean hasInfoPhases() {
        return this.infoPhases != null && !this.infoPhases.isEmpty();
    }

    public List<EPPLaunchPolicyInfoPhase> getInfoPhases() {
        return this.infoPhases;
    }

    public void setInfoPhases(List<EPPLaunchPolicyInfoPhase> aInfoPhases) {
        this.infoPhases = aInfoPhases == null ? new ArrayList<EPPLaunchPolicyInfoPhase>() : aInfoPhases;
    }

    public void addInfoPhase(EPPLaunchPolicyInfoPhase aInfoPhase) {
        if (this.infoPhases == null) {
            this.infoPhases = new ArrayList<EPPLaunchPolicyInfoPhase>();
        }
        this.infoPhases.add(aInfoPhase);
    }

    public boolean hasCreateForms() {
        return this.createForms != null && !this.createForms.isEmpty();
    }

    public List<CreateForm> getCreateForms() {
        return this.createForms;
    }

    public void setCreateForms(List<CreateForm> aCreateForms) {
        this.createForms = aCreateForms == null ? new ArrayList<CreateForm>() : aCreateForms;
    }

    public void addCreateForm(CreateForm aCreateForm) {
        if (this.createForms == null) {
            this.createForms = new ArrayList<CreateForm>();
        }
        this.createForms.add(aCreateForm);
    }

    public boolean hasCreateValidateType() {
        return this.createValidateType != null;
    }

    public Boolean getCreateValidateType() {
        return this.createValidateType;
    }

    public void setCreateValidateType(Boolean aCreateValidateType) {
        this.createValidateType = aCreateValidateType;
    }

    public static enum CreateForm implements Serializable,
    Cloneable
    {
        sunrise,
        claims,
        general,
        mixed;

    }

    public static enum CheckForm implements Serializable,
    Cloneable
    {
        claims,
        availability,
        trademark;

    }

    public static enum MarkValidation implements Serializable,
    Cloneable
    {
        code,
        mark,
        codeWithMark,
        signedMark;

    }

    public static enum Mode {
        fcfs("fcfs"),
        pendingRegistration("pending-registration"),
        pendingApplication("pending-application");

        private final String modeStr;

        private Mode(String aModeStr) {
            this.modeStr = aModeStr;
        }

        public static Mode getMode(String aString) {
            if (aString.equals(Mode.fcfs.modeStr)) {
                return fcfs;
            }
            if (aString.equals(Mode.pendingRegistration.modeStr)) {
                return pendingRegistration;
            }
            if (aString.equals(Mode.pendingApplication.modeStr)) {
                return pendingApplication;
            }
            throw new InvalidParameterException("Mode enum value of " + aString + " is not valid.");
        }

        public String toString() {
            return this.modeStr;
        }
    }

    public static enum Phase {
        preDelegation("pre-delegation"),
        preLaunch("pre-launch"),
        sunrise("sunrise"),
        landrush("landrush"),
        claims("claims"),
        open("open"),
        custom("custom");

        private final String phaseStr;

        private Phase(String aPhaseStr) {
            this.phaseStr = aPhaseStr;
        }

        public static Phase getPhase(String aString) {
            if (aString.equals(Phase.preDelegation.phaseStr)) {
                return preDelegation;
            }
            if (aString.equals(Phase.preLaunch.phaseStr)) {
                return preLaunch;
            }
            if (aString.equals(Phase.sunrise.phaseStr)) {
                return sunrise;
            }
            if (aString.equals(Phase.landrush.phaseStr)) {
                return landrush;
            }
            if (aString.equals(Phase.claims.phaseStr)) {
                return claims;
            }
            if (aString.equals(Phase.open.phaseStr)) {
                return open;
            }
            if (aString.equals(Phase.custom.phaseStr)) {
                return custom;
            }
            throw new InvalidParameterException("Phase enum value of " + aString + " is not valid.");
        }

        public String toString() {
            return this.phaseStr;
        }
    }
}

