/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPExtFactory;
import com.verisign.epp.codec.gen.EPPProtocolExtension;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.launch.EPPLaunchCheck;
import com.verisign.epp.codec.launch.EPPLaunchChkData;
import com.verisign.epp.codec.launch.EPPLaunchCreData;
import com.verisign.epp.codec.launch.EPPLaunchCreate;
import com.verisign.epp.codec.launch.EPPLaunchDelete;
import com.verisign.epp.codec.launch.EPPLaunchInfData;
import com.verisign.epp.codec.launch.EPPLaunchInfo;
import com.verisign.epp.codec.launch.EPPLaunchUpdate;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPLaunchExtFactory
extends EPPExtFactory {
    public static final String NS = "urn:ietf:params:xml:ns:launch-1.0";
    public static final String NS_PREFIX = "launch";
    private EPPService service = new EPPService("launch", "urn:ietf:params:xml:ns:launch-1.0");

    public EPPLaunchExtFactory() {
        this.service.setServiceType(1);
    }

    @Override
    public EPPProtocolExtension createProtocolExtension(Element aExtensionElm) throws EPPCodecException {
        throw new EPPCodecException("EPPLaunchExtFactory.createProtocolExtension: Protocol extensions not supported");
    }

    @Override
    public EPPCodecComponent createExtension(Element aExtensionElm) throws EPPCodecException {
        String name = aExtensionElm.getLocalName();
        if (!aExtensionElm.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid extension type " + name);
        }
        String localName = aExtensionElm.getLocalName();
        if (localName.equals("check")) {
            return new EPPLaunchCheck();
        }
        if (localName.equals("chkData")) {
            return new EPPLaunchChkData();
        }
        if (localName.equals("info")) {
            return new EPPLaunchInfo();
        }
        if (localName.equals("infData")) {
            return new EPPLaunchInfData();
        }
        if (localName.equals("create")) {
            return new EPPLaunchCreate();
        }
        if (localName.equals("creData")) {
            return new EPPLaunchCreData();
        }
        if (localName.equals("update")) {
            return new EPPLaunchUpdate();
        }
        if (localName.equals("delete")) {
            return new EPPLaunchDelete();
        }
        throw new EPPCodecException("Invalid extension element " + name);
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    public Set getXmlSchemas() {
        LinkedHashSet<String> theSchemas = new LinkedHashSet<String>();
        theSchemas.add("xmldsig-core-schema.xsd");
        theSchemas.add("mark-1.0.xsd");
        theSchemas.add("signedMark-1.0.xsd");
        theSchemas.add("launch-1.0.xsd");
        return theSchemas;
    }
}

