/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPInfoCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPIdnTableInfoCmd
extends EPPInfoCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPIdnTableInfoCmd.class);
    public static final String ELM_LOCALNAME = "info";
    public static final String ELM_NAME = "idnTable:info";
    private static final String ELM_DOMAIN = "domain";
    private static final String ELM_TABLE = "table";
    private static final String ELM_LIST = "list";
    private String domain;
    private String table;
    private Form form = Form.UNDEFINED_FORM;

    public EPPIdnTableInfoCmd() {
    }

    public EPPIdnTableInfoCmd(String aTransId) {
        super(aTransId);
    }

    public EPPIdnTableInfoCmd(String aTransId, Form aForm, String aValue) {
        super(aTransId);
        this.setForm(aForm);
        switch (aForm) {
            case DOMAIN_FORM: {
                this.setDomain(aValue);
                break;
            }
            case TABLE_FORM: {
                this.setTable(aValue);
                break;
            }
        }
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:idnTable-1.0";
    }

    public boolean hasDomain() {
        return this.domain != null;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String aDomain) {
        this.domain = aDomain;
        if (this.domain != null) {
            this.setForm(Form.DOMAIN_FORM);
        }
    }

    public boolean hasTable() {
        return this.table != null;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String aTable) {
        this.table = aTable;
        if (this.table != null) {
            this.setForm(Form.TABLE_FORM);
        }
    }

    public Form getForm() {
        return this.form;
    }

    public void setForm(Form aForm) {
        this.form = aForm;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.getForm() == Form.UNDEFINED_FORM) {
            throw new EPPEncodeException("Undefined form in EPPIdnTableInfoCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", ELM_NAME);
        switch (this.form) {
            case DOMAIN_FORM: {
                if (this.domain == null) {
                    throw new EPPEncodeException("domain is null in EPPIdnTableInfoCmd with Domain Info Form");
                }
                EPPUtil.encodeString(aDocument, root, this.domain, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:domain");
                break;
            }
            case TABLE_FORM: {
                if (this.table == null) {
                    throw new EPPEncodeException("table is null in EPPIdnTableInfoCmd with Table Info Form");
                }
                EPPUtil.encodeString(aDocument, root, this.table, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:table");
                break;
            }
            case LIST_FORM: {
                Element listElm = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:list");
                root.appendChild(listElm);
            }
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.domain = null;
        this.table = null;
        this.setForm(Form.UNDEFINED_FORM);
        this.domain = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_DOMAIN);
        if (this.domain != null) {
            this.setForm(Form.DOMAIN_FORM);
            return;
        }
        this.table = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_TABLE);
        if (this.table != null) {
            this.setForm(Form.TABLE_FORM);
            return;
        }
        if (EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_LIST) != null) {
            this.setForm(Form.LIST_FORM);
        }
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnTableInfoCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPIdnTableInfoCmd other = (EPPIdnTableInfoCmd)aObject;
        if (!EqualityUtil.equals(this.domain, other.domain)) {
            cat.error("EPPIdnTableInfoCmd.equals(): domain not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.table, other.table)) {
            cat.error("EPPIdnTableInfoCmd.equals(): table not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnTableInfoCmd clone = (EPPIdnTableInfoCmd)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public static enum Form {
        UNDEFINED_FORM,
        DOMAIN_FORM,
        TABLE_FORM,
        LIST_FORM;

    }
}

