/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idnmap;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPExtFactory;
import com.verisign.epp.codec.gen.EPPProtocolExtension;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.idnmap.EPPIdnMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPIdnMapExtFactory
extends EPPExtFactory {
    public static final String NS = "urn:ietf:params:xml:ns:idn-1.0";
    public static final String NS_PREFIX = "idn";
    private EPPService service = new EPPService("idn", "urn:ietf:params:xml:ns:idn-1.0");

    public EPPIdnMapExtFactory() {
        this.service.setServiceType(1);
    }

    @Override
    public EPPCodecComponent createExtension(Element aExtensionElm) throws EPPCodecException {
        String name = aExtensionElm.getLocalName();
        if (!aExtensionElm.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid extension type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("idn:data"))) {
            return new EPPIdnMap();
        }
        throw new EPPCodecException("Invalid extension element " + name);
    }

    @Override
    public EPPProtocolExtension createProtocolExtension(Element aExtensionElm) throws EPPCodecException {
        throw new EPPCodecException("EPPIdnMapExtFactory.createProtocolExtension: Protocol extensions not supported");
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    public Set getXmlSchemas() {
        LinkedHashSet<String> theSchemas = new LinkedHashSet<String>();
        theSchemas.add("idn-1.0.xsd");
        return theSchemas;
    }
}

