/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idnext;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.idnext.EPPIdnLangTag;
import com.verisign.epp.util.TestThread;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPIdnExtTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPIdnExtTst(String name) {
        super(name);
    }

    public void testDomainCreateCommandWithIdnLangExt() {
        EPPCodecTst.printStart("testDomainCreateCommandWithIdnLangExt");
        EPPDomainCreateCmd theDomainCommand = new EPPDomainCreateCmd("ABC-12345", "john.doe.name", new EPPAuthInfo("2fooBAR"));
        Vector<EPPCodecComponent> commandExtensions = new Vector<EPPCodecComponent>();
        commandExtensions.add(new EPPIdnLangTag("en"));
        theDomainCommand.setExtensions(commandExtensions);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainCreateCommandWithIdnLangExt");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPIdnExtTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.idnext.EPPIdnExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPIdnExtFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPIdnExtTst Thread " + i, EPPIdnExtTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPIdnExtTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

