/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.host;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPInfoCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPHostInfoCmd
extends EPPInfoCmd {
    public static final String ELM_LOCALNAME = "info";
    public static final String ELM_NAME = "host:info";
    private static final String ELM_HOST_NAME = "name";
    private String name;

    public EPPHostInfoCmd() {
        this.name = null;
    }

    public EPPHostInfoCmd(String aTransId, String aName) {
        super(aTransId);
        this.name = aName;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:host-1.0";
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("required attribute name is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:host-1.0", "host:name");
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPHostInfoCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPHostInfoCmd theComp = (EPPHostInfoCmd)aObject;
        return this.name != null ? this.name.equals(theComp.name) : theComp.name == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPHostInfoCmd clone = (EPPHostInfoCmd)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

