/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Iterator;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EPPRecipient
implements EPPCodecComponent {
    static final String ELM_NAME = "recipient";
    private static final String ELM_OTHER = "other";
    private static final String ELM_OURS = "ours";
    private static final String ELM_OURS_DESC = "recDesc";
    private static final String ELM_PUBLIC = "public";
    private static final String ELM_SAME = "same";
    private static final String ELM_UNRELATED = "unrelated";
    private static Logger cat = LoggerFactory.getLogger(EPPRecipient.class);
    private boolean otherRecipient = false;
    private Vector<String> oursRecipient = null;
    private boolean publicRecipient = false;
    private boolean sameRecipient = false;
    private boolean unrelatedRecipient = false;

    public EPPRecipient() {
    }

    public EPPRecipient(boolean aOther, Vector<String> aOurs, boolean aPublic, boolean aSame, boolean aUnrelated) {
        this.otherRecipient = aOther;
        this.oursRecipient = aOurs;
        this.publicRecipient = aPublic;
        this.sameRecipient = aSame;
        this.unrelatedRecipient = aUnrelated;
    }

    public boolean isOther() {
        return this.otherRecipient;
    }

    public void setOther(boolean aOther) {
        this.otherRecipient = aOther;
    }

    public Vector<String> getOurs() {
        return this.oursRecipient;
    }

    public void setOurs(Vector<String> aOurs) {
        this.oursRecipient = aOurs;
    }

    public void addOurs(String aOursDesc) {
        if (this.oursRecipient == null) {
            this.oursRecipient = new Vector();
        }
        this.oursRecipient.add(aOursDesc);
    }

    public boolean isPublic() {
        return this.publicRecipient;
    }

    public void setPublic(boolean aPublic) {
        this.publicRecipient = aPublic;
    }

    public boolean isSame() {
        return this.sameRecipient;
    }

    public void setSame(boolean aSame) {
        this.sameRecipient = aSame;
    }

    public boolean isUnrelated() {
        return this.unrelatedRecipient;
    }

    public void setUnrelated(boolean aUnrelated) {
        this.unrelatedRecipient = aUnrelated;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (!(this.otherRecipient || this.oursRecipient != null || this.publicRecipient || this.sameRecipient || this.unrelatedRecipient)) {
            cat.error("EPPRecipient.encode(): At least one recipient must be set");
            throw new EPPEncodeException("EPPRecipient.encode(): At least one recipient must be set");
        }
        Element theElm = null;
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        if (this.otherRecipient) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_OTHER);
            root.appendChild(theElm);
        }
        if (this.oursRecipient != null) {
            Iterator<String> theIter = this.oursRecipient.iterator();
            while (theIter.hasNext()) {
                Element theOursElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_OURS);
                root.appendChild(theOursElm);
                String theDesc = theIter.next();
                if (theDesc == null) continue;
                EPPUtil.encodeString(aDocument, theOursElm, theDesc, "urn:ietf:params:xml:ns:epp-1.0", ELM_OURS_DESC);
            }
        }
        if (this.publicRecipient) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_PUBLIC);
            root.appendChild(theElm);
        }
        if (this.sameRecipient) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_SAME);
            root.appendChild(theElm);
        }
        if (this.unrelatedRecipient) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_UNRELATED);
            root.appendChild(theElm);
        }
        return root;
    }

    private void reset() {
        this.otherRecipient = false;
        this.oursRecipient = null;
        this.publicRecipient = false;
        this.sameRecipient = false;
        this.unrelatedRecipient = false;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        NodeList theList = aElement.getChildNodes();
        this.reset();
        for (int i = 0; i < theList.getLength(); ++i) {
            Node theNode = theList.item(i);
            if (theNode.getNodeType() != 1) continue;
            Element theElm = (Element)theNode;
            if (theElm.getLocalName().equals(EPPUtil.getLocalName(ELM_OTHER))) {
                this.otherRecipient = true;
                continue;
            }
            if (theElm.getLocalName().equals(ELM_OURS)) {
                String theDesc = EPPUtil.decodeString(theElm, "urn:ietf:params:xml:ns:epp-1.0", EPPUtil.getLocalName(ELM_OURS_DESC));
                this.addOurs(theDesc);
                continue;
            }
            if (theElm.getLocalName().equals(EPPUtil.getLocalName(ELM_PUBLIC))) {
                this.publicRecipient = true;
                continue;
            }
            if (theElm.getLocalName().equals(EPPUtil.getLocalName(ELM_SAME))) {
                this.sameRecipient = true;
                continue;
            }
            if (theElm.getLocalName().equals(EPPUtil.getLocalName(ELM_UNRELATED))) {
                this.unrelatedRecipient = true;
                continue;
            }
            cat.error("EPPRecipient.decode(): Unknown element " + theElm);
            throw new EPPDecodeException("EPPRecipient.decode(): Unknown element " + theElm);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRecipient)) {
            cat.error("EPPRecipient.equals(): " + aObject.getClass().getName() + " not EPPRecipient instance");
            return false;
        }
        EPPRecipient theRecipient = (EPPRecipient)aObject;
        if (this.otherRecipient != theRecipient.otherRecipient) {
            cat.error("EPPRecipient.equals(): otherRecipient not equal");
            return false;
        }
        if (!EPPUtil.equalVectors(this.oursRecipient, theRecipient.oursRecipient)) {
            cat.error("EPPRecipient.equals(): oursRecipient not equal");
            return false;
        }
        if (this.publicRecipient != theRecipient.publicRecipient) {
            cat.error("EPPRecipient.equals(): publicRecipient not equal");
            return false;
        }
        if (this.sameRecipient != theRecipient.sameRecipient) {
            cat.error("EPPRecipient.equals(): sameRecipient not equal");
            return false;
        }
        if (this.unrelatedRecipient != theRecipient.unrelatedRecipient) {
            cat.error("EPPRecipient.equals(): unrelatedRecipient not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRecipient clone = null;
        clone = (EPPRecipient)super.clone();
        clone.oursRecipient = this.oursRecipient != null ? (Vector)this.oursRecipient.clone() : null;
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }
}

