/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPComponentNotFoundException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPHello;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.gen.EPPProtocolExtension;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EPPCodec {
    public static final String VERSION = "1.0";
    public static final String NS = "urn:ietf:params:xml:ns:epp-1.0";
    public static final String NS_SCHEMA = "urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd";
    private static EPPCodec instance = new EPPCodec();
    private static Logger cat = LoggerFactory.getLogger(EPPCodec.class);
    private final String ELM_EPP = "epp";

    protected EPPCodec() {
    }

    public static EPPCodec getInstance() {
        return instance;
    }

    public void init(Vector<String> someFactories) throws EPPCodecException {
        cat.debug("init(Vector): enter");
        EPPFactory.getInstance().init(someFactories);
        cat.debug("init(Vector): exit");
    }

    public void init(Vector<String> someFactories, Vector<String> extensionFactories) throws EPPCodecException {
        cat.debug("init(Vector, Vector): enter");
        EPPFactory.getInstance().init(someFactories, extensionFactories);
        cat.debug("init(Vector, Vector): exit");
    }

    public Document encode(EPPMessage aMessage) throws EPPEncodeException {
        DocumentImpl document = new DocumentImpl();
        Element root = document.createElementNS(NS, "epp");
        root.appendChild(aMessage.encode((Document)document));
        document.appendChild(root);
        return document;
    }

    public EPPMessage decode(Document aDocument) throws EPPDecodeException {
        return this.decode(aDocument.getDocumentElement());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EPPMessage decode(Element root) throws EPPDecodeException, EPPComponentNotFoundException {
        void var2_12;
        Object var2_2 = null;
        if (!NS.equals(root.getNamespaceURI()) || !root.getLocalName().equals("epp")) {
            throw new EPPDecodeException("Invalid root element NS = " + root.getNamespaceURI() + ", name = " + root.getLocalName());
        }
        Element messageType = EPPUtil.getFirstElementChild(root);
        if (messageType == null) {
            throw new EPPDecodeException("No element child was found from the root node");
        }
        if (NS.equals(root.getNamespaceURI()) && messageType.getLocalName().equals(EPPUtil.getLocalName("greeting"))) {
            EPPGreeting ePPGreeting = new EPPGreeting();
        } else if (NS.equals(root.getNamespaceURI()) && messageType.getLocalName().equals(EPPUtil.getLocalName("hello"))) {
            EPPHello ePPHello = new EPPHello();
        } else if (NS.equals(root.getNamespaceURI()) && messageType.getLocalName().equals(EPPUtil.getLocalName("command"))) {
            Element commandType = EPPUtil.getFirstElementChild(messageType);
            if (commandType == null) {
                throw new EPPDecodeException("Command Type Element could not be found");
            }
            String commandTypeName = commandType.getLocalName();
            Element commandMap = EPPUtil.getFirstElementChild(commandType);
            if (commandMap != null && commandMap.getLocalName().startsWith(commandTypeName)) {
                try {
                    EPPCommand ePPCommand = EPPFactory.getInstance().createCommand(commandMap);
                }
                catch (EPPCodecException e) {
                    throw new EPPComponentNotFoundException(1, "Unable to create concrete command for type " + commandTypeName + ": " + e);
                }
            } else {
                String op = commandType.getAttribute("op");
                try {
                    EPPCommand ePPCommand = EPPFactory.getInstance().createCommand(commandTypeName, op);
                }
                catch (EPPCodecException e) {
                    throw new EPPComponentNotFoundException(1, "Unable to create concrete command for type " + commandTypeName + " and op " + op + " : " + e);
                }
            }
        } else if (NS.equals(root.getNamespaceURI()) && messageType.getLocalName().equals(EPPUtil.getLocalName("response"))) {
            NodeList responseDataElm = messageType.getElementsByTagNameNS(NS, EPPUtil.getLocalName("resData"));
            switch (responseDataElm.getLength()) {
                case 0: {
                    EPPResponse ePPResponse = new EPPResponse();
                    break;
                }
                case 1: {
                    Element responseMap = EPPUtil.getFirstElementChild((Element)responseDataElm.item(0));
                    if (responseMap == null) {
                        throw new EPPDecodeException("No child element found for resData");
                    }
                    try {
                        EPPResponse ePPResponse = EPPFactory.getInstance().createResponse(responseMap);
                        break;
                    }
                    catch (EPPCodecException e) {
                        throw new EPPComponentNotFoundException(2, "Unable to create concrete response: " + e);
                    }
                }
                default: {
                    throw new EPPDecodeException("Invalid number of resData elements of " + responseDataElm.getLength());
                }
            }
        } else {
            if (!NS.equals(root.getNamespaceURI()) || !messageType.getLocalName().equals(EPPUtil.getLocalName("extension"))) throw new EPPDecodeException("Invalid message tag name of " + messageType.getTagName());
            Element extensionElm = EPPUtil.getFirstElementChild(messageType);
            if (extensionElm == null) throw new EPPDecodeException("No child element found for the protocol extension");
            try {
                EPPProtocolExtension ePPProtocolExtension = EPPFactory.getInstance().createProtocolExtension(extensionElm);
            }
            catch (EPPCodecException e) {
                throw new EPPComponentNotFoundException(3, "EPPCommand.decode unable to create protocol extension object: " + e);
            }
        }
        var2_12.decode(messageType);
        return var2_12;
    }

    public EPPCommand decodeCommand(Document aDocument) throws EPPDecodeException {
        EPPMessage theMessage = this.decode(aDocument);
        if (!(theMessage instanceof EPPCommand)) {
            throw new EPPDecodeException("Decoded message is not an EPPCommand on call to decodeCommand");
        }
        return (EPPCommand)theMessage;
    }

    public EPPResponse decodeResponse(Document aDocument) throws EPPDecodeException {
        EPPMessage theMessage = this.decode(aDocument);
        if (!(theMessage instanceof EPPResponse)) {
            throw new EPPDecodeException("Decoded message is not an EPPResponse on call to decodeResponse");
        }
        return (EPPResponse)theMessage;
    }

    public EPPGreeting decodeGreeting(Document aDocument) throws EPPDecodeException {
        EPPMessage theMessage = this.decode(aDocument);
        if (!(theMessage instanceof EPPGreeting)) {
            throw new EPPDecodeException("Decoded message is not an EPPGreeting on call to decodeGreeting");
        }
        return (EPPGreeting)theMessage;
    }

    public EPPHello decodeHello(Document aDocument) throws EPPDecodeException {
        EPPMessage theMessage = this.decode(aDocument);
        if (!(theMessage instanceof EPPHello)) {
            throw new EPPDecodeException("Decoded message is not an EPPHello on call to decodeHello");
        }
        return (EPPHello)theMessage;
    }
}

