/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.domain.EPPDomainAddRemove;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUpdateCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainUpdateCmd
extends EPPUpdateCmd {
    public static final String ELM_LOCALNAME = "update";
    public static final String ELM_NAME = "domain:update";
    private static final String ELM_DOMAIN_NAME = "name";
    private String name = null;
    private EPPDomainAddRemove add = null;
    private EPPDomainAddRemove remove = null;
    private EPPDomainAddRemove change = null;

    public EPPDomainUpdateCmd() {
    }

    public EPPDomainUpdateCmd(String aName) {
        this.name = aName;
    }

    public EPPDomainUpdateCmd(String aTransId, String aName, EPPDomainAddRemove aAdd, EPPDomainAddRemove aRemove, EPPDomainAddRemove aChange) {
        super(aTransId);
        this.name = aName;
        this.setAdd(aAdd);
        this.setRemove(aRemove);
        this.setChange(aChange);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("name required attribute is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:domain-1.0", "domain:name");
        EPPUtil.encodeComp(aDocument, root, this.add);
        EPPUtil.encodeComp(aDocument, root, this.remove);
        EPPUtil.encodeComp(aDocument, root, this.change);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        this.add = (EPPDomainAddRemove)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "add", EPPDomainAddRemove.class);
        if (this.add != null) {
            this.add.setMode((short)1);
        }
        this.remove = (EPPDomainAddRemove)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "rem", EPPDomainAddRemove.class);
        if (this.remove != null) {
            this.remove.setMode((short)2);
        }
        this.change = (EPPDomainAddRemove)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "chg", EPPDomainAddRemove.class);
        if (this.change != null) {
            this.change.setMode((short)3);
        }
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainUpdateCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPDomainUpdateCmd theComp = (EPPDomainUpdateCmd)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        if (!(this.add != null ? this.add.equals(theComp.add) : theComp.add == null)) {
            return false;
        }
        if (!(this.remove != null ? this.remove.equals(theComp.remove) : theComp.remove == null)) {
            return false;
        }
        return this.change != null ? this.change.equals(theComp.change) : theComp.change == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainUpdateCmd clone = (EPPDomainUpdateCmd)super.clone();
        if (clone.add != null) {
            clone.add = (EPPDomainAddRemove)this.add.clone();
        }
        if (clone.remove != null) {
            clone.remove = (EPPDomainAddRemove)this.remove.clone();
        }
        if (clone.change != null) {
            clone.change = (EPPDomainAddRemove)this.change.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean hasAdd() {
        return this.add != null;
    }

    public EPPDomainAddRemove getAdd() {
        return this.add;
    }

    public void setAdd(EPPDomainAddRemove aAdd) {
        this.add = aAdd;
        if (this.add != null) {
            this.add.setMode((short)1);
        }
    }

    public boolean hasRemove() {
        return this.remove != null;
    }

    public EPPDomainAddRemove getRemove() {
        return this.remove;
    }

    public void setRemove(EPPDomainAddRemove aRemove) {
        this.remove = aRemove;
        if (this.remove != null) {
            this.remove.setMode((short)2);
        }
    }

    public boolean hasChange() {
        return this.change != null;
    }

    public EPPDomainAddRemove getChange() {
        return this.change;
    }

    public void setChange(EPPDomainAddRemove newChange) {
        this.change = newChange;
        if (this.change != null) {
            this.change.setMode((short)3);
        }
    }
}

