/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.domain.EPPDomainAddRemove;
import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCheckResult;
import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPendActionMsg;
import com.verisign.epp.codec.domain.EPPDomainPeriod;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.domain.EPPHostAttr;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.host.EPPHostAddress;
import com.verisign.epp.util.TestThread;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPDomainTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPDomainTst(String name) {
        super(name);
    }

    public void testDomainInfo() {
        EPPCodecTst.printStart("testDomainInfo");
        EPPDomainInfoCmd theCommand = new EPPDomainInfoCmd("ABC-12345", "example.com");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainInfoCmd("ABC-12349", "example.com");
        theCommand.setHosts("del");
        theCommand.setAuthInfo(new EPPAuthInfo("2fooBAR"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "example.com", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse.setRegistrant("JD1234-VRSN");
        theResponse.addNs("ns1.example.com");
        theResponse.addNs("ns2.example.com");
        Vector<String> hosts = new Vector<String>();
        hosts.addElement("ns1.example.com");
        hosts.addElement("ns2.example.com");
        theResponse.setHosts(hosts);
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            theResponse.addContact(new EPPDomainContact("SH8013-VRSN", "admin"));
        }
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastTransferDate(new Date());
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse.setTransId(respTransId);
        theResponse.setRoid("EXAMPLE1-VRSN");
        theResponse.setResult(1000);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "example.com", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        theResponse.addStatus(new EPPDomainStatus("ok"));
        theResponse.addNsAttr(new EPPHostAttr("ns1.example.com"));
        theResponse.addNsAttr(new EPPHostAttr("ns2.example.com"));
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastTransferDate(new Date());
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse.setTransId(respTransId);
        theResponse.setRoid("EXAMPLE1-VRSN");
        theResponse.setResult(1000);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainInfo");
    }

    public void testDomainPendActionMsg() {
        EPPCodecTst.printStart("testDomainPendActionMsg");
        EPPTransId thePollTransId = new EPPTransId("ABC-12349", "54321-XYZ");
        EPPTransId thePendingTransId = new EPPTransId("DEF-12349", "12345-XYZ");
        EPPDomainPendActionMsg theMsg = new EPPDomainPendActionMsg(thePollTransId, "example.com", false, thePendingTransId, new Date());
        theMsg.setResult(1301);
        Assert.assertEquals((String)"testDomainPendActionMsg: response success is incorrect", (boolean)theMsg.isSuccess(), (boolean)true);
        Assert.assertEquals((String)"testDomainPendActionMsg: PA success is incorrect", (boolean)theMsg.isPASuccess(), (boolean)false);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theMsg);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainPendActionMsg");
    }

    public void testDomainCreate() {
        EPPCodecTst.printStart("testDomainCreate");
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd("ABC-12345", "example.com", new EPPAuthInfo("2fooBAR"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<String> servers = new Vector<String>();
        servers.addElement("ns1.example.com");
        servers.addElement("ns2.example.com");
        Vector<EPPDomainContact> contacts = null;
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            contacts = new Vector<EPPDomainContact>();
            contacts.addElement(new EPPDomainContact("SH8013-VRSN", "admin"));
            contacts.addElement(new EPPDomainContact("SH8013-VRSN", "tech"));
        }
        theCommand = new EPPDomainCreateCmd("ABC-12345-XYZ", "example.com", servers, contacts, new EPPDomainPeriod(2), new EPPAuthInfo("2fooBAR"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainCreateCmd("ABC-12345", "example.com", new EPPAuthInfo("2fooBAR"));
        Vector<EPPHostAttr> serverAttrs = new Vector<EPPHostAttr>();
        serverAttrs.add(new EPPHostAttr("ns1.example.com"));
        Vector<EPPHostAddress> hostAddresses = new Vector<EPPHostAddress>();
        hostAddresses.add(new EPPHostAddress("197.162.10.10"));
        serverAttrs.add(new EPPHostAttr("ns2.example.com", hostAddresses));
        theCommand.setServerAttrs(serverAttrs);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainCreateResp theResponse = new EPPDomainCreateResp(respTransId, "example.com", new GregorianCalendar(2001, 5, 5).getTime(), new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainCreate");
    }

    public void testDomainDelete() {
        EPPCodecTst.printStart("testDomainDelete");
        EPPDomainDeleteCmd theCommand = new EPPDomainDeleteCmd("ABC-12345", "example.com");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainDelete");
    }

    public void testDomainRenew() {
        EPPCodecTst.printStart("testDomainRenew");
        Calendar theCal = Calendar.getInstance();
        theCal.setTimeZone(TimeZone.getTimeZone("UTC"));
        theCal.set(2000, 6, 22, 0, 0, 0);
        theCal.set(14, 0);
        Date theDate = theCal.getTime();
        EPPDomainRenewCmd theCommand = new EPPDomainRenewCmd("ABC-12345", "exampleZ.com", theDate, new EPPDomainPeriod(5));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainRenewResp theResponse = new EPPDomainRenewResp(respTransId, "exampleX.com", new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainRenew");
    }

    public void testDomainUpdate() {
        EPPCodecTst.printStart("testDomainUpdate");
        Vector<String> addServers = new Vector<String>();
        addServers.addElement("ns2.example.com");
        Vector<EPPDomainStatus> addStatuses = new Vector<EPPDomainStatus>();
        addStatuses.addElement(new EPPDomainStatus("clientHold", "Payment overdue."));
        Vector<EPPDomainContact> addContacts = null;
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            addContacts = new Vector<EPPDomainContact>();
            addContacts.addElement(new EPPDomainContact("mak21", "tech"));
        }
        EPPDomainAddRemove addItems = new EPPDomainAddRemove(addServers, addContacts, addStatuses);
        EPPDomainAddRemove removeItems = new EPPDomainAddRemove();
        removeItems.addServer("ns1.example.com");
        removeItems.addStatus(new EPPDomainStatus("clientUpdateProhibited"));
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            removeItems.addContact(new EPPDomainContact("sh8013", "tech"));
        }
        EPPDomainAddRemove changeItems = new EPPDomainAddRemove();
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            changeItems.setRegistrant("sh8013");
        }
        changeItems.setAuthInfo(new EPPAuthInfo("2BARfoo"));
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("ABC-12345", "example.com", addItems, removeItems, changeItems);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<EPPHostAttr> addAddrServers = new Vector<EPPHostAttr>();
        EPPHostAttr hostAddr = new EPPHostAttr("ns1.example.net");
        hostAddr.addAddress(new EPPHostAddress("192.0.2.2", 0));
        hostAddr.addAddress(new EPPHostAddress("1080:0:0:0:8:800:200C:417A", 1));
        addAddrServers.add(hostAddr);
        addItems = new EPPDomainAddRemove(addAddrServers, null, null);
        removeItems = new EPPDomainAddRemove();
        removeItems.addServer(new EPPHostAttr("ns2.example.net"));
        theCommand = new EPPDomainUpdateCmd("ABC-12345", "example2.com", addItems, removeItems, null);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPDomainAddRemove emptyChangeItems = new EPPDomainAddRemove();
        Assert.assertTrue((boolean)emptyChangeItems.isEmpty());
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainUpdate");
    }

    public void testDomainTransfer() {
        EPPCodecTst.printStart("testDomainTransfer");
        EPPDomainTransferCmd theCommand = new EPPDomainTransferCmd("ABC-12345", "request", "example.com", new EPPAuthInfo("2fooBAR"), new EPPDomainPeriod(1));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPAuthInfo theAuthInfo = new EPPAuthInfo("2fooBAR");
        theAuthInfo.setRoid("JD1234-REP");
        theCommand = new EPPDomainTransferCmd("ABC-12345", "request", "example.com", theAuthInfo, new EPPDomainPeriod(1));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainTransferResp theResponse = new EPPDomainTransferResp(respTransId, "example.com");
        theResponse.setResult(1000);
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setTransferStatus("pending");
        theResponse.setRequestDate(new Date());
        theResponse.setActionDate(new Date());
        theResponse.setExpirationDate(new Date());
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPDomainTransferCmd("ABC-12345", "cancel", "example.com");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainTransferCmd("ABC-12345", "query", "example.com");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainTransferCmd("ABC-12345", "reject", "example.com");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainTransferCmd("ABC-12345", "approve", "example.com");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainTransfer");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPDomainTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPDomainTst Thread " + i, EPPDomainTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPDomainTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    public void testDomainCheck() {
        EPPCodecTst.printStart("testDomainCheck");
        EPPDomainCheckCmd theCommand = new EPPDomainCheckCmd("ABC-12345", "example.com");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<String> domains = new Vector<String>();
        domains.addElement("example1.com");
        domains.addElement("example2.com");
        domains.addElement("example3.com");
        theCommand = new EPPDomainCheckCmd("ABC-12345-XYZ", domains);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainCheckResp theResponse = new EPPDomainCheckResp(respTransId, new EPPDomainCheckResult("example1.com", true));
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        Vector<EPPDomainCheckResult> domainResults = new Vector<EPPDomainCheckResult>();
        domainResults.addElement(new EPPDomainCheckResult("example1.com", true));
        EPPDomainCheckResult domainResult = new EPPDomainCheckResult("example2.com", false);
        domainResult.setDomainReason("In Use");
        domainResult.setLanguage("fr");
        domainResults.addElement(domainResult);
        domainResults.addElement(new EPPDomainCheckResult("example3.com", true));
        theResponse = new EPPDomainCheckResp(respTransId, domainResults);
        theResponse.setResult(1000);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainCheck");
    }
}

