/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPendActionMsg;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPMapFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPDomainMapFactory
extends EPPMapFactory {
    public static final String NS = "urn:ietf:params:xml:ns:domain-1.0";
    public static final String NS_PREFIX = "domain";
    public static final String NS_CONTACT = "urn:ietf:params:xml:ns:contact-1.0";
    public static final String ELM_DOMAIN_AUTHINFO = "domain:authInfo";
    private EPPService service = new EPPService("domain", "urn:ietf:params:xml:ns:domain-1.0");

    @Override
    public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("domain:check"))) {
            return new EPPDomainCheckCmd();
        }
        if (name.equals(EPPUtil.getLocalName("domain:info"))) {
            return new EPPDomainInfoCmd();
        }
        if (name.equals(EPPUtil.getLocalName("domain:create"))) {
            return new EPPDomainCreateCmd();
        }
        if (name.equals(EPPUtil.getLocalName("domain:delete"))) {
            return new EPPDomainDeleteCmd();
        }
        if (name.equals(EPPUtil.getLocalName("domain:renew"))) {
            return new EPPDomainRenewCmd();
        }
        if (name.equals(EPPUtil.getLocalName("domain:update"))) {
            return new EPPDomainUpdateCmd();
        }
        if (name.equals(EPPUtil.getLocalName("domain:transfer"))) {
            return new EPPDomainTransferCmd();
        }
        throw new EPPCodecException("Invalid command type " + name);
    }

    @Override
    public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("domain:chkData"))) {
            return new EPPDomainCheckResp();
        }
        if (name.equals(EPPUtil.getLocalName("domain:infData"))) {
            return new EPPDomainInfoResp();
        }
        if (name.equals(EPPUtil.getLocalName("domain:creData"))) {
            return new EPPDomainCreateResp();
        }
        if (name.equals(EPPUtil.getLocalName("domain:renData"))) {
            return new EPPDomainRenewResp();
        }
        if (name.equals(EPPUtil.getLocalName("domain:trnData"))) {
            return new EPPDomainTransferResp();
        }
        if (name.equals(EPPUtil.getLocalName("domain:panData"))) {
            return new EPPDomainPendActionMsg();
        }
        throw new EPPCodecException("Invalid response element " + name);
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    @Override
    public Set<String> getXmlSchemas() {
        HashSet<String> theSchemas = new HashSet<String>();
        theSchemas.add("domain-1.0.xsd");
        return theSchemas;
    }
}

