/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.defReg;

import com.verisign.epp.codec.defReg.EPPDefRegAddRemove;
import com.verisign.epp.codec.defReg.EPPDefRegCheckCmd;
import com.verisign.epp.codec.defReg.EPPDefRegCheckResp;
import com.verisign.epp.codec.defReg.EPPDefRegCheckResult;
import com.verisign.epp.codec.defReg.EPPDefRegCreateCmd;
import com.verisign.epp.codec.defReg.EPPDefRegCreateResp;
import com.verisign.epp.codec.defReg.EPPDefRegDeleteCmd;
import com.verisign.epp.codec.defReg.EPPDefRegInfoCmd;
import com.verisign.epp.codec.defReg.EPPDefRegInfoResp;
import com.verisign.epp.codec.defReg.EPPDefRegName;
import com.verisign.epp.codec.defReg.EPPDefRegPeriod;
import com.verisign.epp.codec.defReg.EPPDefRegRenewCmd;
import com.verisign.epp.codec.defReg.EPPDefRegRenewResp;
import com.verisign.epp.codec.defReg.EPPDefRegStatus;
import com.verisign.epp.codec.defReg.EPPDefRegTransferCmd;
import com.verisign.epp.codec.defReg.EPPDefRegTransferResp;
import com.verisign.epp.codec.defReg.EPPDefRegUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.idnext.EPPIdnLangTag;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPPDefRegTst {
    private static long numIterations = 1L;

    @Test
    public void testDefRegInfo() {
        EPPCodecTst.printStart("testDefRegInfo");
        EPPDefRegInfoCmd theCommand = new EPPDefRegInfoCmd("ABC-12349", "EXAMPLE1-REP");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<EPPDefRegStatus> statuses = new Vector<EPPDefRegStatus>();
        statuses.addElement(new EPPDefRegStatus("ok"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        Calendar theCal = Calendar.getInstance();
        theCal.setTimeZone(TimeZone.getTimeZone("UTC"));
        theCal.set(2000, 6, 22, 0, 0, 0);
        theCal.set(14, 0);
        Date theTmDate = theCal.getTime();
        EPPDefRegInfoResp theResponse = new EPPDefRegInfoResp(respTransId, new EPPDefRegName("premium", "ibm"), "EXAMPLE1-REP", "registrant", "ibm", "US", theTmDate, "registrant", statuses, "ClientY", "registrant", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse = new EPPDefRegInfoResp();
        theResponse.setName(new EPPDefRegName("premium", "ibm"));
        theResponse.setRoid("EXAMPLE1-REP");
        theResponse.setClientId("ClientX");
        theResponse.setResult(1000);
        theResponse.setTransId(respTransId);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDefRegInfo");
    }

    @Test
    public void testDefRegCreate() {
        EPPCodecTst.printStart("testDefRegCreate");
        Calendar theCal = Calendar.getInstance();
        theCal.setTimeZone(TimeZone.getTimeZone("UTC"));
        theCal.set(2000, 6, 22, 0, 0, 0);
        theCal.set(14, 0);
        Date theTmDate = theCal.getTime();
        EPPDefRegCreateCmd theCommand = new EPPDefRegCreateCmd("ABC-12345", new EPPDefRegName("premium", "ibm"), "XYZ", "ibm", "US", theTmDate, "registrant", new EPPDefRegPeriod(10), new EPPAuthInfo("2fooBAR"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println("the command status is" + commandStats);
        System.out.println("coming until here");
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDefRegCreateResp theResponse = new EPPDefRegCreateResp(respTransId, new EPPDefRegName("premium", "verisign"), "XYZ-ABC", new GregorianCalendar(2001, 5, 5).getTime(), new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDefRegCreate");
    }

    @Test
    public void testDefRegCreateIDN() {
        EPPCodecTst.printStart("testDefRegCreateIDN");
        Calendar theCal = Calendar.getInstance();
        theCal.setTimeZone(TimeZone.getTimeZone("UTC"));
        theCal.set(2000, 6, 22, 0, 0, 0);
        theCal.set(14, 0);
        Date theTmDate = theCal.getTime();
        EPPDefRegCreateCmd theDefRegCommand = new EPPDefRegCreateCmd("ABC-12345-XYZ", new EPPDefRegName("premium", "xn--gya"), "sh8013", "Example", "US", theTmDate, "SH8013", new EPPDefRegPeriod(2), new EPPAuthInfo("2fooBAR"));
        theDefRegCommand.addExtension(new EPPIdnLangTag("GRE"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theDefRegCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDefRegCreateIDN");
    }

    @Test
    public void testDefRegDelete() {
        EPPCodecTst.printStart("testDefRegDelete");
        EPPDefRegDeleteCmd theCommand = new EPPDefRegDeleteCmd("XYZ", "EXAMPLE1-REP");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDefRegDelete");
    }

    @Test
    public void testDefRegRenew() {
        EPPCodecTst.printStart("testDefRegRenew");
        Calendar theCal = Calendar.getInstance();
        theCal.setTimeZone(TimeZone.getTimeZone("UTC"));
        theCal.set(2000, 6, 22, 0, 0, 0);
        theCal.set(14, 0);
        Date theDate = theCal.getTime();
        EPPDefRegRenewCmd theCommand = new EPPDefRegRenewCmd("ABC-12345", "EXAMPLE1-REP", theDate, new EPPDefRegPeriod(5));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDefRegRenewResp theResponse = new EPPDefRegRenewResp(respTransId, "EXAMPLE1-REP", new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDefRegRenew");
    }

    @Test
    public void testDefRegUpate() {
        EPPCodecTst.printStart("testDefRegUpate");
        Vector<EPPDefRegStatus> addStatuses = new Vector<EPPDefRegStatus>();
        addStatuses.addElement(new EPPDefRegStatus("clientUpdateProhibited", "en"));
        Vector<EPPDefRegStatus> removeStatuses = new Vector<EPPDefRegStatus>();
        removeStatuses.addElement(new EPPDefRegStatus("clientDeleteProhibited"));
        EPPDefRegAddRemove addItems = new EPPDefRegAddRemove(addStatuses);
        EPPDefRegAddRemove removeItems = new EPPDefRegAddRemove(removeStatuses);
        Calendar theCal = Calendar.getInstance();
        theCal.setTimeZone(TimeZone.getTimeZone("UTC"));
        theCal.set(2000, 6, 22, 0, 0, 0);
        theCal.set(14, 0);
        Date theTmDate = theCal.getTime();
        EPPDefRegAddRemove changeItems = new EPPDefRegAddRemove("IBMREGISTRANT", "ibm", "US", theTmDate, "registrant", new EPPAuthInfo("2fooBAR"));
        EPPDefRegUpdateCmd theCommand = new EPPDefRegUpdateCmd("ABC-12345-XYZ", "EXAMPLE1-REP", addItems, removeItems, changeItems);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDefRegUpate");
    }

    @Test
    public void testDefRegTransfer() {
        EPPCodecTst.printStart("testDefRegTransfer");
        EPPDefRegTransferCmd theCommand = new EPPDefRegTransferCmd("ABC-12345", "request", "EXAMPLE1-REP", new EPPAuthInfo("2fooBAR"), new EPPDefRegPeriod(1));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDefRegTransferResp theResponse = new EPPDefRegTransferResp(respTransId, "EXAMPLE1-REP");
        theResponse.setResult(1000);
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setTransferStatus("pending");
        theResponse.setRequestDate(new Date());
        theResponse.setActionDate(new Date());
        theResponse.setExpirationDate(new Date());
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPDefRegTransferCmd("ABC-12345", "cancel", "EXAMPLE1-REP");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDefRegTransferCmd("ABC-12345", "query", "EXAMPLE1-REP");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDefRegTransferCmd("ABC-12345", "reject", "EXAMPLE1-REP");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        theCommand = new EPPDefRegTransferCmd("ABC-12345", "approve", "EXAMPLE1-REP");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDefRegTransfer");
    }

    @BeforeClass
    public static void beforeClass() {
        EPPCodecTst.initEnvironment();
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.defReg.EPPDefRegMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.idnext.EPPIdnExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDefRegMapFactory to EPPCodec: " + e));
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    @Test
    public void testDefRegCheck() {
        EPPCodecTst.printStart("testDefRegCheck");
        Vector<EPPDefRegName> defRegs = new Vector<EPPDefRegName>();
        defRegs.addElement(new EPPDefRegName("premium", "ibm"));
        defRegs.addElement(new EPPDefRegName("premium", "verisign"));
        defRegs.addElement(new EPPDefRegName("standard", "java.sun.name"));
        EPPDefRegCheckCmd theCommand = new EPPDefRegCheckCmd("ABC-12345-XYZ", defRegs);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        Vector<EPPDefRegCheckResult> defReg = new Vector<EPPDefRegCheckResult>();
        defReg.addElement(new EPPDefRegCheckResult("ash.SUNW****com", "standard", true));
        EPPDefRegCheckResp theResponse = new EPPDefRegCheckResp(respTransId, defReg);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println("now the response is" + responseStats);
        Vector<EPPDefRegCheckResult> defRegResults = new Vector<EPPDefRegCheckResult>();
        defRegResults.addElement(new EPPDefRegCheckResult("ibm", "premium", true));
        EPPDefRegCheckResult defRegResult = new EPPDefRegCheckResult("ash.ibm.com", "standard", false);
        defRegResult.setDefRegReason("In use");
        defRegResult.setLanguage("fr");
        defRegResults.addElement(defRegResult);
        theResponse = new EPPDefRegCheckResp(respTransId, defRegResults);
        theResponse.setResult(1000);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDefRegCheck");
    }
}

