/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPTransferCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPContactTransferCmd
extends EPPTransferCmd {
    static final String ELM_NAME = "contact:transfer";
    private static final String ELM_CONTACT_ID = "contact:id";
    private static final String ELM_CONTACT_AUTHINFO = "contact:authInfo";
    private static final String ELM_CONTACT_TRANSFER_OP = "request";
    private String id = null;
    private EPPAuthInfo authInfo = null;

    public EPPContactTransferCmd() {
        this.id = null;
        this.authInfo = null;
    }

    public EPPContactTransferCmd(String aTransId, String aOp, String aId) {
        super(aTransId, aOp);
        this.id = aId;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:contact-1.0";
    }

    @Override
    public String getKey() {
        return this.getId();
    }

    void validateState() throws EPPCodecException {
        if (super.getOp() == null) {
            throw new EPPCodecException("op required attribute is not set");
        }
        if (this.id == null) {
            throw new EPPCodecException("id required attribute is not set");
        }
        if (super.getOp().equals(ELM_CONTACT_TRANSFER_OP) && this.authInfo == null) {
            throw new EPPCodecException("authInfo required attribute is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("EPPContactTransferCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        root.setAttribute("xmlns:contact", "urn:ietf:params:xml:ns:contact-1.0");
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO, EPPAuthInfo.class);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactTransferCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPContactTransferCmd theMap = (EPPContactTransferCmd)aObject;
        if (!(this.id != null ? this.id.equals(theMap.id) : theMap.id == null)) {
            return false;
        }
        return this.authInfo != null ? this.authInfo.equals(theMap.authInfo) : theMap.authInfo == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPContactTransferCmd clone = (EPPContactTransferCmd)super.clone();
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO);
        }
    }
}

