/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPContactCreateResp
extends EPPResponse {
    static final String ELM_NAME = "contact:creData";
    private static final String ELM_CREATION_DATE = "contact:crDate";
    private static final String ELM_CONTACT_ID = "contact:id";
    private String id;
    private Date creationDate = null;

    public EPPContactCreateResp() {
        this.id = null;
    }

    public EPPContactCreateResp(EPPTransId aTransId, String aId, Date aCreationDate) {
        super(aTransId);
        this.id = aId;
        this.creationDate = aCreationDate;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:contact-1.0";
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date newCrDate) {
        this.creationDate = newCrDate;
    }

    void validateState() throws EPPCodecException {
        if (this.id == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.creationDate == null) {
            throw new EPPCodecException("required attribute creationDate is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPContactCreateResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        root.setAttribute("xmlns:contact", "urn:ietf:params:xml:ns:contact-1.0");
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        EPPUtil.encodeTimeInstant(aDocument, root, this.creationDate, "urn:ietf:params:xml:ns:contact-1.0", ELM_CREATION_DATE);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        this.creationDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CREATION_DATE);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPContactCreateResp.decode: " + e);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactCreateResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPContactCreateResp theComp = (EPPContactCreateResp)aObject;
        return this.id != null ? this.id.equals(theComp.id) : theComp.id == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPContactCreateResp clone = (EPPContactCreateResp)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

