/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCreateCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EqualityUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPContactCreateCmd
extends EPPCreateCmd {
    static final String ELM_NAME = "contact:create";
    private static final String ELM_CONTACT_POSTAL_INFO = "contact:postalInfo";
    private static final String ELM_CONTACT_AUTHINFO = "contact:authInfo";
    private static final String ELM_CONTACT_EMAIL = "contact:email";
    private static final String ELM_CONTACT_FAX = "contact:fax";
    private static final String ELM_CONTACT_ID = "contact:id";
    private static final String ELM_CONTACT_VOICE = "contact:voice";
    private static final String ELM_CONTACT_DISCLOSE = "contact:disclose";
    private static final String ATTR_EXT = "x";
    private Vector postalContacts = new Vector();
    private EPPAuthInfo authInfo = null;
    private EPPContactDisclose disclose = null;
    private String email = null;
    private String fax = null;
    private String faxExt = null;
    private String id = null;
    private String voice = null;
    private String voiceExt = null;

    public EPPContactCreateCmd() {
    }

    public EPPContactCreateCmd(String aTransId) {
        super(aTransId);
    }

    public EPPContactCreateCmd(String aTransId, String aId, EPPContactPostalDefinition aPostalContact, String aEmail, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.id = aId;
        this.postalContacts.add(aPostalContact);
        this.voice = null;
        this.fax = null;
        this.email = aEmail;
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:contact-1.0";
    }

    @Override
    public String getKey() {
        return this.getId();
    }

    private void validateState() throws EPPCodecException {
        if (!this.hasId()) {
            throw new EPPCodecException("required attribute contact id is not set");
        }
        if (!this.hasPostalContacts()) {
            throw new EPPCodecException("required attribute contact postalInfo is not set");
        }
        if (!this.hasEmail()) {
            throw new EPPCodecException("required attribute contact email is not set");
        }
        if (!this.hasAuthInfo()) {
            throw new EPPCodecException("required attribute contact authInfo is not set");
        }
    }

    private void relaxedValidateState() throws EPPCodecException {
        if (!this.hasId()) {
            throw new EPPCodecException("required attribute contact id is not set");
        }
        if (!this.hasPostalContacts()) {
            throw new EPPCodecException("required attribute contact postalInfo is not set");
        }
        if (!this.hasAuthInfo()) {
            throw new EPPCodecException("required attribute contact authInfo is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element currElm = null;
        Text currVal = null;
        try {
            if (EPPEnv.isContactRelaxedValidation()) {
                this.relaxedValidateState();
            } else {
                this.validateState();
            }
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPContactCreateCmd.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        root.setAttribute("xmlns:contact", "urn:ietf:params:xml:ns:contact-1.0");
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        EPPUtil.encodeCompVector(aDocument, root, this.postalContacts);
        if (this.hasVoice()) {
            currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
            currVal = aDocument.createTextNode(this.voice);
            if (this.hasVoiceExt()) {
                currElm.setAttribute(ATTR_EXT, this.voiceExt);
            }
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        if (this.hasFax()) {
            currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
            currVal = aDocument.createTextNode(this.fax);
            if (this.hasFaxExt()) {
                currElm.setAttribute(ATTR_EXT, this.faxExt);
            }
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_EMAIL);
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        EPPUtil.encodeComp(aDocument, root, this.disclose);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element currElm = null;
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        this.postalContacts = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_POSTAL_INFO, EPPContactPostalDefinition.class);
        this.voice = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
        if (this.hasVoice()) {
            currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
            this.voiceExt = currElm.getAttribute(ATTR_EXT);
            if (this.voiceExt.length() == 0) {
                this.voiceExt = null;
            }
        } else {
            this.voiceExt = null;
        }
        this.fax = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
        if (this.hasFax()) {
            currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
            this.faxExt = currElm.getAttribute(ATTR_EXT);
            if (this.faxExt.length() == 0) {
                this.faxExt = null;
            }
        } else {
            this.faxExt = null;
        }
        this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_EMAIL);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO, EPPAuthInfo.class);
        this.disclose = (EPPContactDisclose)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_DISCLOSE, EPPContactDisclose.class);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactCreateCmd) || !super.equals(aObject)) {
            return false;
        }
        EPPContactCreateCmd theComp = (EPPContactCreateCmd)aObject;
        if (!EqualityUtil.equals(this.id, theComp.id)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.postalContacts, theComp.postalContacts)) {
            return false;
        }
        if (!EqualityUtil.equals(this.voice, theComp.voice)) {
            return false;
        }
        if (!EqualityUtil.equals(this.voiceExt, theComp.voiceExt)) {
            return false;
        }
        if (!EqualityUtil.equals(this.fax, theComp.fax)) {
            return false;
        }
        if (!EqualityUtil.equals(this.faxExt, theComp.faxExt)) {
            return false;
        }
        if (!EqualityUtil.equals(this.email, theComp.email)) {
            return false;
        }
        if (!EqualityUtil.equals(this.authInfo, theComp.authInfo)) {
            return false;
        }
        return EqualityUtil.equals(this.disclose, theComp.disclose);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPContactCreateCmd clone = (EPPContactCreateCmd)super.clone();
        if (this.hasPostalContacts()) {
            clone.postalContacts = (Vector)this.postalContacts.clone();
            for (int i = 0; i < this.postalContacts.size(); ++i) {
                clone.postalContacts.setElementAt(((EPPContactPostalDefinition)this.postalContacts.elementAt(i)).clone(), i);
            }
        }
        if (this.hasAuthInfo()) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.hasDisclose()) {
            clone.disclose = (EPPContactDisclose)this.disclose.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasPostalContacts() {
        return this.postalContacts != null && this.postalContacts.elements().hasMoreElements();
    }

    public Vector getPostalInfo() {
        return this.postalContacts;
    }

    public void setPostalInfo(Vector newPostalContacts) {
        this.postalContacts = newPostalContacts;
    }

    public void addPostalInfo(EPPContactPostalDefinition newPostalInfo) {
        EPPContactPostalDefinition aPostalContact = null;
        if (newPostalInfo != null) {
            try {
                aPostalContact = (EPPContactPostalDefinition)newPostalInfo.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            this.postalContacts.add(newPostalInfo);
        }
    }

    public boolean hasAuthInfo() {
        return this.authInfo != null;
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO);
        }
    }

    public boolean hasDisclose() {
        return this.disclose != null;
    }

    public EPPContactDisclose getDisclose() {
        return this.disclose;
    }

    public void setDisclose(EPPContactDisclose newDisclose) {
        if (newDisclose != null) {
            this.disclose = newDisclose;
            this.disclose.setRootName(ELM_CONTACT_DISCLOSE);
        }
    }

    public boolean hasEmail() {
        return this.email != null;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String newEmail) {
        this.email = newEmail;
    }

    public boolean hasFax() {
        return this.fax != null;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String newFax) {
        this.fax = newFax;
    }

    public boolean hasFaxExt() {
        return this.faxExt != null;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String newFaxExt) {
        this.faxExt = newFaxExt;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public boolean hasVoice() {
        return this.voice != null;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String newVoice) {
        this.voice = newVoice;
    }

    public boolean hasVoiceExt() {
        return this.voiceExt != null;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String newVoiceExt) {
        this.voiceExt = newVoiceExt;
    }
}

