/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.coaext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPCoaExtValue
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private static Logger cat = LoggerFactory.getLogger(EPPCoaExtValue.class);
    public static final String ELM_NAME = "coa:value";
    private String value;

    public EPPCoaExtValue() {
    }

    public EPPCoaExtValue(String aValue) {
        this.value = aValue;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPCoaExtValue clone = null;
        clone = (EPPCoaExtValue)super.clone();
        clone.setValue(this.getValue());
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPCoaExtValue.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPCoaExtValue.encode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPCoaExtValue invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPCoaExtValue.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:coa-1.0", ELM_NAME);
        Text valueText = aDocument.createTextNode(this.value);
        root.appendChild(valueText);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Text valueText = (Text)aElement.getFirstChild();
        this.value = valueText == null ? null : valueText.getData();
    }

    void validateState() throws EPPCodecException {
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPCoaExtValue)) {
            return false;
        }
        EPPCoaExtValue theComp = (EPPCoaExtValue)aObject;
        return this.value.equalsIgnoreCase(theComp.getValue());
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:coa-1.0";
    }
}

