/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.coaext;

import com.verisign.epp.codec.coaext.EPPCoaExtAttr;
import com.verisign.epp.codec.coaext.EPPCoaExtCreate;
import com.verisign.epp.codec.coaext.EPPCoaExtInfData;
import com.verisign.epp.codec.coaext.EPPCoaExtKey;
import com.verisign.epp.codec.coaext.EPPCoaExtUpdate;
import com.verisign.epp.codec.coaext.EPPCoaExtValue;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import java.util.Date;
import java.util.Vector;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPPCoaExtTst {
    private static long numIterations = 1L;

    @Test
    public void testDomainCreateCommandWithCoaExt() {
        EPPCodecTst.printStart("testDomainCreateCommandWithCoaExt");
        EPPDomainCreateCmd theDomainCommand = new EPPDomainCreateCmd("ABC-12345", "john.doe.com", new EPPAuthInfo("2fooBAR@"));
        Vector<EPPCodecComponent> commandExtensions = new Vector<EPPCodecComponent>();
        EPPCoaExtAttr attr = new EPPCoaExtAttr();
        attr.setKey(new EPPCoaExtKey("KEY1"));
        attr.setValue(new EPPCoaExtValue("value1"));
        EPPCoaExtCreate create = new EPPCoaExtCreate();
        create.appendAttr(attr);
        commandExtensions.add(create);
        theDomainCommand.setExtensions(commandExtensions);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainCreateCommandWithCoaExt");
    }

    @Test
    public void testDomainUpdateCommandWithCoaExtPut() {
        EPPCodecTst.printStart("testDomainUpdateCommandWithCoaExt");
        EPPDomainUpdateCmd theDomainCommand = new EPPDomainUpdateCmd("john.doe.name");
        Vector<EPPCodecComponent> commandExtensions = new Vector<EPPCodecComponent>();
        EPPCoaExtAttr addAttr = new EPPCoaExtAttr();
        addAttr.setKey(new EPPCoaExtKey("KEY1"));
        addAttr.setValue(new EPPCoaExtValue("value1"));
        EPPCoaExtUpdate updateCmd = new EPPCoaExtUpdate();
        updateCmd.appendPutAttr(addAttr);
        commandExtensions.add(updateCmd);
        theDomainCommand.setExtensions(commandExtensions);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdateCommandWithCoaExt");
    }

    @Test
    public void testDomainUpdateCommandWithCoaExtRem() {
        EPPCodecTst.printStart("testDomainUpdateCommandWithCoaExtRem");
        EPPDomainUpdateCmd theDomainCommand = new EPPDomainUpdateCmd("john.doe.name");
        Vector<EPPCodecComponent> commandExtensions = new Vector<EPPCodecComponent>();
        EPPCoaExtKey remKey = new EPPCoaExtKey("KEY1");
        EPPCoaExtUpdate updateCmd = new EPPCoaExtUpdate();
        updateCmd.appendRemAttr(remKey);
        commandExtensions.add(updateCmd);
        theDomainCommand.setExtensions(commandExtensions);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdateCommandWithCoaExtRem");
    }

    @Test
    public void testDomainUpdateCommandWithCoaExtAll() {
        EPPCodecTst.printStart("testDomainUpdateCommandWithCoaExtAll");
        EPPDomainUpdateCmd theDomainCommand = new EPPDomainUpdateCmd("john.doe.name");
        Vector<EPPCodecComponent> commandExtensions = new Vector<EPPCodecComponent>();
        EPPCoaExtUpdate updateCmd = new EPPCoaExtUpdate();
        EPPCoaExtKey remKey = new EPPCoaExtKey("KEY1");
        updateCmd.appendRemAttr(remKey);
        EPPCoaExtAttr addAttr = new EPPCoaExtAttr();
        addAttr.setKey(new EPPCoaExtKey("KEY2"));
        addAttr.setValue(new EPPCoaExtValue("value2"));
        updateCmd.appendPutAttr(addAttr);
        commandExtensions.add(updateCmd);
        theDomainCommand.setExtensions(commandExtensions);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdateCommandWithCoaExtAll");
    }

    @Test
    public void testDomainInfoRespWithCoaExtRem() {
        EPPCodecTst.printStart("testDomainInfoRespWithCoaExtRem");
        EPPTransId respTransId = new EPPTransId("54321-CLI", "54321-SER");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "example.tv", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        EPPCoaExtAttr attr = new EPPCoaExtAttr();
        attr.setKey(new EPPCoaExtKey("KEY1"));
        attr.setValue(new EPPCoaExtValue("value1"));
        EPPCoaExtInfData infData = new EPPCoaExtInfData();
        infData.appendAttr(attr);
        theResponse.addExtension(infData);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainInfoRespWithCoaExtRem");
    }

    @BeforeClass
    public static void beforeClass() {
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.coaext.EPPCoaExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPCoaExtFactory to EPPCodec: " + e));
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

