/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.changepoll;

import com.verisign.epp.codec.changepoll.EPPChangeCaseId;
import com.verisign.epp.codec.changepoll.EPPChangeData;
import com.verisign.epp.codec.changepoll.EPPChangeOperation;
import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMsgQueue;
import com.verisign.epp.codec.gen.EPPTransId;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPPChangePollTst {
    private static long numIterations = 1L;

    @Test
    public void testChangePoll() {
        EPPCodecTst.printStart("testChangePoll");
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("serverUpdateProhibited"));
        statuses.addElement(new EPPDomainStatus("serverDeleteProhibited"));
        statuses.addElement(new EPPDomainStatus("serverTransferProhibited"));
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-REP", "domain.example", "ClientX", statuses, "ClientY", new GregorianCalendar(2012, 4, 3).getTime(), null);
        theResponse.setResult(1301);
        theResponse.setMsgQueue(new EPPMsgQueue((Long)1L, "202", new GregorianCalendar(2013, 10, 22).getTime(), "Registry initiated update of domain."));
        theResponse.setRegistrant("jd1234");
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            Vector<EPPDomainContact> contacts = new Vector<EPPDomainContact>();
            contacts.addElement(new EPPDomainContact("sh8013", "admin"));
            contacts.addElement(new EPPDomainContact("sh8013", "tech"));
            theResponse.setContacts(contacts);
        }
        theResponse.setLastUpdatedBy("ClientZ");
        theResponse.setLastUpdatedDate(new GregorianCalendar(2013, 10, 22).getTime());
        theResponse.setExpirationDate(new GregorianCalendar(2014, 4, 3).getTime());
        EPPDomainInfoResp ursLockResponse = null;
        try {
            ursLockResponse = (EPPDomainInfoResp)theResponse.clone();
        }
        catch (CloneNotSupportedException e1) {
            Assert.fail((String)"Exception cloning domain info response for URS Lock Change Poll Extension with Before State");
        }
        EPPChangeData changeData = new EPPChangeData(new EPPChangeOperation("update"), new GregorianCalendar(2013, 10, 22).getTime(), "12345-XYZ", "URS Admin", "before", new EPPChangeCaseId("urs123", "urs"), "URS Lock", null);
        ursLockResponse.addExtension(changeData);
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(ursLockResponse);
        System.out.println(theStats);
        try {
            ursLockResponse = (EPPDomainInfoResp)theResponse.clone();
        }
        catch (CloneNotSupportedException e1) {
            Assert.fail((String)"Exception cloning domain info response for URS Lock Change Poll Extension with After State");
        }
        changeData = new EPPChangeData(new EPPChangeOperation("update"), new GregorianCalendar(2013, 10, 22).getTime(), "12345-XYZ", "URS Admin", "after", new EPPChangeCaseId("urs123", "urs"), "URS Lock", null);
        ursLockResponse.addExtension(changeData);
        theStats = EPPCodecTst.testEncodeDecode(ursLockResponse);
        System.out.println(theStats);
        EPPDomainInfoResp custSyncResponse = null;
        try {
            custSyncResponse = (EPPDomainInfoResp)theResponse.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.fail((String)"Exception cloning domain info response for Customer Sync Change Poll Extension");
        }
        changeData = new EPPChangeData(new EPPChangeOperation("custom", "sync"), new GregorianCalendar(2013, 10, 22).getTime(), "12345-XYZ", "CSR", "after", null, "Customer sync request", null);
        custSyncResponse.addExtension(changeData);
        theStats = EPPCodecTst.testEncodeDecode(custSyncResponse);
        System.out.println(theStats);
        Object deletePurgeResponse = null;
        try {
            custSyncResponse = (EPPDomainInfoResp)theResponse.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.fail((String)"Exception cloning domain info response for Delete Purge Change Poll Extension");
        }
        changeData = new EPPChangeData(new EPPChangeOperation("delete", "purge"), new GregorianCalendar(2013, 10, 22).getTime(), "12345-XYZ", "CSR", "after", new EPPChangeCaseId("internal123", "custom", "Internal"), "La demande du Client", "fr");
        custSyncResponse.addExtension(changeData);
        theStats = EPPCodecTst.testEncodeDecode(custSyncResponse);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testChangePoll");
    }

    @BeforeClass
    public static void beforeClass() {
        EPPCodecTst.initEnvironment();
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.changepoll.EPPChangePollExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

