/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.allocationtoken;

import com.verisign.epp.codec.allocationtoken.EPPAllocationToken;
import com.verisign.epp.codec.allocationtoken.EPPAllocationTokenInfo;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPPAllocationTokenTst {
    private static long numIterations = 1L;

    @Test
    public void testAllocationToken() {
        EPPCodecTst.printStart("testAllocationToken");
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPDomainCreateCmd theDomainCommand = new EPPDomainCreateCmd("ABC-12345", "example.tld", new EPPAuthInfo("2fooBAR"));
        theDomainCommand.addExtension(new EPPAllocationToken("abc123"));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testAllocationToken");
    }

    @Test
    public void testAllocationTokenInfo() {
        EPPCodecTst.printStart("testAllocationTokenInfo");
        EPPDomainInfoCmd theDomainCommand = new EPPDomainInfoCmd("ABC-12345", "example.tld");
        theDomainCommand.addExtension(new EPPAllocationTokenInfo());
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testAllocationTokenInfo");
    }

    @BeforeClass
    public static void setup() {
        EPPCodecTst.initEnvironment();
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.allocationtoken.EPPAllocationTokenExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

